#ifndef HEADER_BANDIT_ALG
#define HEADER_BANDIT_ALG

#include <vector>
#include <cstdint>

/*********************************************************
* inherit from this class if you want to define a new 
* noise model. Must implement access to the mean for
* the purpose of computing the regret. Must also
* implement a way to sample from the ith arm.
*********************************************************/
class BanditProblem {
  public:
  /* returns a sample from the ith arm */
  virtual double        sample(int i) = 0;         
  /* returns the mean of the ith arm */
  virtual double        mean(int i) = 0;           

  /* returns the gap for the ith arm */
  double gap(int i);                        

  /* initialises the gaps */
  void setup();                              

  uint64_t n;
  int K;
  private:
  std::vector<double> gaps;
};


/*********************************************************
* new bandit algorithms should inherit from this class.
*********************************************************/
class BanditAlgorithm {
  public:
  /* give the algorithm the next reward */
  virtual void give_reward(double r) = 0;   
  /* get the next arm */
  virtual int get_arm() = 0;             
  /* returns identifier for the algorithm */
  virtual void setup(uint64_t n, int K);

  protected:

  uint64_t n;
  int K;
};


#endif
