source("./Rcode/gFITC.R")
source("./Rcode/epGPC.R")

setwd("./data")
source("generate_data.R")
setwd("..")

library(ROCR)
library(doMC)
registerDoMC(cores = 4)

set.seed(0)
load("./data/data.dat")

for (npi in c(200)) {
	foreach (i = 1 : 100) %dopar% {
	
		print(i)
	
		# We prepare the data
	
		Xtrain <- data$x[ data$itrain[ i, ], ]
		Ytrain <- as.vector(c(data$y_train[ i, ]))
		Xtest <- data$x[ data$itest[ i, ], ]
		Ytest <- as.vector(c(data$y_test[ i, ]))
	
		meanTrain <- apply(Xtrain, 2, mean)
		sdTrain <- apply(Xtrain, 2, sd)
		sdTrain[ sdTrain == 0 ] <- 1

		Xtrain <- (Xtrain - matrix(meanTrain, nrow(Xtrain), ncol(Xtrain), byrow = TRUE)) / 
			matrix(sdTrain, nrow(Xtrain), ncol(Xtrain), byrow = TRUE)
		Xtest <- (Xtest - matrix(meanTrain, nrow(Xtest), ncol(Xtest), byrow = TRUE)) / 
			matrix(sdTrain, nrow(Xtest), ncol(Xtest), byrow = TRUE)

		# We do PCA dimensionality reduction

		pca <- prcomp(Xtrain, scale = FALSE, center = FALSE)

		Xtrain <- Xtrain %*% pca$rotation[, 1 : 50 ]
		Xtest <- Xtest %*% pca$rotation[, 1 : 50 ]
	
		ret <- epGPCExternal(Xtrain, Ytrain, npi, l = 5e-2, sigma0 = 1, optimize_flags = c(FALSE, TRUE, TRUE, TRUE))
	
		errorTrain <- mean(sign(predictGPC(ret, Xtrain) - 0.5) != Ytrain)
		errorTest <- mean(sign(predictGPC(ret, Xtest) - 0.5) != Ytest)

		write.table(errorTest, file = paste("./results/GPC/errorTest_X_", npi, "_", i, ".txt", sep = ""),
			row.names = F, col.names = F, append = TRUE)
	}
}


