library(ROCR)
source("./Rcode/gFITC.R")
source("./Rcode/epAGPC_het.R")

setwd("./data")
source("generate_data.R")
setwd("..")

# We add a bias term

library(doMC)
registerDoMC(cores = 4)

load("./data/data.dat")

for (npi in c(200)) {
	foreach  (i = 1 : 100) %dopar% {

		print(i)

		# We prepare the data
	
		Xtrain <- data$x[ data$itrain[ i, ], ]
		Ytrain <- as.vector(c(data$y_train[ i, ]))
		Xtest <- data$x[ data$itest[ i, ], ]
		Ytest <- as.vector(c(data$y_test[ i, ]))
		Xtrain_star <- data$x_star[ data$itrain[ i, ], ]
		Xtest_star <- data$x_star[ data$itest[ i, ], ]

		meanTrain <- apply(Xtrain, 2, mean)
		sdTrain <- apply(Xtrain, 2, sd)
		sdTrain[ sdTrain == 0 ] <- 1

		Xtrain <- (Xtrain - matrix(meanTrain, nrow(Xtrain), ncol(Xtrain), byrow = TRUE)) / 
			matrix(sdTrain, nrow(Xtrain), ncol(Xtrain), byrow = TRUE)
		Xtest <- (Xtest - matrix(meanTrain, nrow(Xtest), ncol(Xtest), byrow = TRUE)) / 
			matrix(sdTrain, nrow(Xtest), ncol(Xtest), byrow = TRUE)
	
		# We do PCA dimensionality reduction

		pca <- prcomp(Xtrain, scale = FALSE, center = FALSE)

		Xtrain <- Xtrain %*% pca$rotation[, 1 : 50 ]
		Xtest <- Xtest %*% pca$rotation[, 1 : 50 ]

		meanTrain_star <- apply(Xtrain_star, 2, mean)
		sdTrain_star <- apply(Xtrain_star, 2, sd)
		sdTrain_star[ sdTrain_star == 0 ] <- 1

		Xtrain_star <- (Xtrain_star - matrix(meanTrain_star, nrow(Xtrain_star), ncol(Xtrain_star), byrow = TRUE)) / 
			matrix(sdTrain_star, nrow(Xtrain_star), ncol(Xtrain_star), byrow = TRUE)
		Xtest_star <- (Xtest_star - matrix(meanTrain_star, nrow(Xtest_star), ncol(Xtest_star), byrow = TRUE)) / 
			matrix(sdTrain_star, nrow(Xtest_star), ncol(Xtest_star), byrow = TRUE)

		pca <- prcomp(Xtrain_star, scale = FALSE, center = FALSE)

		Xtrain_star <- Xtrain_star %*% pca$rotation[, 1 : 50 ]
		Xtest_star <- Xtest_star %*% pca$rotation[, 1 : 50 ]

		ret <- epGPCExternal(Xtrain, Xtrain_star, Ytrain, npi, sigmaF = 1, sigma0F = 1e-3, 
			lF = 5e-2, sigmaG = 1, sigma0G = 1e-3, lG = 5e-2, optimize_flags_F = c(FALSE, FALSE, TRUE, TRUE),
			optimize_flags_G = c(FALSE, FALSE, TRUE, TRUE, FALSE))

		errorTrain <- mean(sign(predictGPC(ret, Xtrain) - 0.5) != Ytrain)
		errorTest <- mean(sign(predictGPC(ret, Xtest) - 0.5) != Ytest)
		
		write.table(errorTest, file = paste("./results/GPC_priv/errorTest_X_het_", npi, "_", i, ".txt", sep = ""),
			row.names = F, col.names = F, append = TRUE)
	}
}


