clc;
clear;
close all;

addpath('msbm/');
addpath('util/');
addpath('gui/');

fprintf('==============================================================\n');
fprintf('MSBM Interactive GUI\n');
fprintf('--------------------------------------------------------------\n');
fprintf('''A Generative Model for Parts-based Object Segmentation''\n');
fprintf('Neural Information Processing Systems (NIPS) 2012\n');
fprintf('S. M. Ali Eslami, Christopher K. I. Williams\n');
fprintf('==============================================================\n');
fprintf('\n');

% -------------------------------------------------------------------------
% load the MSBM parameters
fprintf('Loading parameters for pedestrians... \t');
theta = deserialize('params/pedestrians_msbm_params.mat');
fprintf('Done.\n');

% -------------------------------------------------------------------------
% load the datasets
fprintf('Loading exemplar pedestrians... \t');
dataset = deserialize('data/pedestrians.mat');
fprintf('Done.\n');

% -------------------------------------------------------------------------
% start the gui
fprintf('Initializing the GUI... \t\t');
msbm_gui(theta, dataset);
fprintf('Done.\n\n');