function [X,P,R,Phi] = spatial_mdp(n,d,k,gamma,l)

X = rand(n,d);
D = (repmat(sum(X.^2,2),1,n) - 2*X*X' + repmat(sum(X.^2,2)',n,1));
K = exp(-D/l^2);
[L,D] = ldl(K);
R = L*sqrt(max(D,0))*randn(n,1);
P = K ./ repmat(sum(K,2), 1, n);

[U,S,V] = svd(inv(eye(n) - gamma*P)*K*inv(eye(n) - gamma*P)');
Phi = V(:,1:k);


