%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% joint_table:
%
% Get contigency table for a set of variables y.
%
% Input:
%
% - y_set: target variables
% - m_all, V_all: parameters of the probit model
%
% Output:
%
% - table: the joint contingency table
%
% Created by: Ricardo Silva, London, 23/05/2011
% University College London
% Current version: 23/05/2011

function table = joint_table(y_set, m_all, V_all)

m = m_all(y_set);
V = V_all(y_set, y_set);
a = zeros(length(y_set), 1); b = zeros(length(y_set), 1);

set_size = length(y_set);
num_comb_v = 2^set_size;
table = zeros(num_comb_v, 1);
set_value = zeros(set_size, 1);
  
for i = 1:num_comb_v
  a(set_value == 0) = -Inf; a(set_value == 1) = -m(set_value == 1);
  b(set_value == 0) = -m(set_value == 0); b(set_value == 1) = Inf;
  table(i) = qscmvnv(2000, V, a, eye(set_size), b);
  set_value = advance_bits(set_value);  
end
