%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% optimize_probitsem_naive:
%
% Choose a subset of variables using the very simple criterion of
% maximizing norm of loadings.
%
% Input:
%
% - K: the total number of variables to keep
% - L, S: model parameters
%
% Output:
%
% - sel_K: the selection of K variables
%
% Created by: Ricardo Silva, London, 26/04/2011
% University College London
%
% Current version: 26/04/2011

function sel_K = optimize_probitsem_naive(K, L, S)

num_x = size(L, 2) - 1;
weights = diag(L(:, 1:num_x) * S * L(:, 1:num_x)');
[~, idx] = sort(weights, 'descend');
sel_K = sort(idx(1:K))';
