%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% summarize_batch_test_synth:
%
% After calculating solutions for the synthetic data using
% 'batch_test_synth', run this to generate the relevant plots comparing the
% four methods (two bound methods + random method + heuristic naive
% method).
%
% This assumes all the corresponding files generated by 'batch_test_synth'
% are available.
%
% Created by: Ricardo Silva, London, 21/04/2011
% University College London
%
% Current version: 24/09/2011

EXP_DIR = 'C:\temp\experiments';
EXP_DIR_SYNTH1 = strcat(EXP_DIR, '\synth\high_signal');
EXP_DIR_SYNTH2 = strcat(EXP_DIR, '\synth\low_signal');

num_y = 40; num_x = 10;
num_trials = 20;
high_K = 32; low_K = 20;

results = zeros(8 * num_trials, 6);
raw_results = zeros(8 * num_trials, 5);
count_r = 1;

high_signal_idx = 1:(4 * num_trials);
low_signal_idx  = (4 * num_trials + 1):(8 * num_trials);

% Load comparisons %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for level = 1:2
  if level == 1
    TARGET_DIR = EXP_DIR_SYNTH1;
    DATA_DIR = 'data\synth\high_signal';
  else
    TARGET_DIR = EXP_DIR_SYNTH2;
    DATA_DIR = 'data\synth\low_signal';
  end
  for s = 1:4 % Style
    for nt = 1:num_trials    
      if s == 1
        STYLE = 'WC'; %Weak coupling, high sparsity
        K = low_K;
      elseif s == 2
        STYLE = 'WC'; %Weak coupling, low sparsity
        K = high_K;
      elseif s == 3
        STYLE = 'SC'; %Strong coupling, high sparsity
        K = low_K;
      else
        STYLE = 'SC'; %Strong coupling, low sparsity
        K = high_K;
      end    
      FILE_NAME = strcat(TARGET_DIR, '\SYNTH_', int2str(num_y), '_', ...
                         int2str(num_x), '_', int2str(K), '_', STYLE, ...
                         '_', int2str(nt), '.mat');
      load(FILE_NAME);
      m1 = mean(mean(abs(mean_bound1 - mean_all)));
      m2 = mean(mean(abs(mean_bound2 - mean_all))); 
      m3 = mean(mean(abs(mean_gauss  - mean_all)));
      m4 = mean(mean(abs(mean_rand   - mean_all)));
      m5 = mean(mean(abs(mean_naive  - mean_all)));
      raw_results(count_r, :) = [m1 m2 m3 m4 m5];
      results(count_r, :) = 1 - [m1 / m4 m2 / m4 m3 / m4 m1 / m5 m2 / m5 m3 / m5];
      disp([m1 m2 m3 m4 m5]);
      disp(results(count_r, :));
      count_r = count_r + 1; 
    end
  end
end

% Plot relevant graphs %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

figure;
scatter(raw_results(high_signal_idx, 2), raw_results(high_signal_idx, end)); 
axis_zero = 0.08;
axis_lim  = 0.30;
xlim([axis_zero axis_lim]); ylim([axis_zero axis_lim]); 
line([axis_zero axis_lim], [axis_zero axis_lim], 'Color', 'black', 'LineStyle', '--');
title('Mean error: high signal', 'FontSize', 24);
xlabel('Tree bound', 'FontSize', 20);
ylabel('Reliability score', 'FontSize', 20);

figure;
scatter(raw_results(low_signal_idx, 2), raw_results(low_signal_idx, end)); 
axis_zero = 0.08;
axis_lim  = 0.30;
xlim([axis_zero axis_lim]); ylim([axis_zero axis_lim]); 
line([axis_zero axis_lim], [axis_zero axis_lim], 'Color', 'black', 'LineStyle', '--');
title('Mean error: low signal', 'FontSize', 24);
xlabel('Tree bound', 'FontSize', 20);
ylabel('Reliability score', 'FontSize', 20);

figure;
boxplot(results(high_signal_idx, :), 'labels', {'N/R', 'T/R', 'G/R', 'N/S', 'T/S', 'G/S'});
title('Improvement ratio: high signal', 'FontSize', 24);

figure;
boxplot(results(low_signal_idx, :), 'labels', {'N/R', 'T/R', 'G/R', 'N/S', 'T/S', 'G/S'});
title('Improvement ratio: low signal', 'FontSize', 24);
