/*---------------------------------------------------
 * file:    sparse.c
 * purpose: Miscellaneous routines for sparse matrices
 * author:  ahollowa@uci.edu
 * date:    12/11/09
 *-------------------------------------------------*/

#include "mylib.h"
#include "sparse.h"

/* Count the number of tokens in the sparse matrix */ 
int countntot(char *fname) 
{
  int count, ntot = 0, temp;
  FILE *fp = fopen(fname ,"r"); assert(fp);
  fscanf(fp,"%d",&temp);
  fscanf(fp,"%d",&temp);
  fscanf(fp,"%d",&temp);
  while (fscanf(fp, "%*d%*d%d", &count) != EOF)
    ntot += count;
  
  fclose(fp);
  assert(ntot>0);
  return ntot;
}

/* Return the dimension of the sparse matrix */
void get_dimension( char *file, int *rows, int *cols){
	FILE *fp = fopen(file, "r");
	assert(fp);
	
	fscanf(fp, "%d", rows);
	fscanf(fp, "%d", cols);
	fclose(fp);
	return;
}

/* Count number of nonzero tokens in sparse matrix */
int countnnz(int nr, int nc, int **x) //
{
  int i, j, nnz=0;
  for (i = 0; i < nr; i++)
    for (j = 0; j < nc; j++)
      if (x[i][j] > 0) nnz++;
  return nnz;
}

/* Count number of lines in file */
int countlines(char *fname) //
{
  int lines = 0;
  char buf[BUFF_SIZE];
  FILE *fp = fopen(fname ,"r"); assert(fp);
  while (fgets(buf, BUFF_SIZE, fp)) lines++;
  fclose(fp);
  assert(lines>0);
  return lines;
}


