/*---------------------------------------------------
 * File:    myio.h
 * purpose: header file for input/output routines
 * author:  ahollowa@uci.edu
 * date:    12/11/2009
 *-------------------------------------------------*/

#ifndef _MYIO_H_
#define _MYIO_H_


void read_dmat(int nr, int nc, double **x, char *fname);

/* Read file in sparse matrix format */
int **read_sparse(char *fname, int *nr_, int *nc_);

/* Read double file in sparse matrix format */
double **read_sparse_d(char *fname, int *nr_, int *nc_);

/* Read integer vetor (convert to zero base indexing)*/
void read_ivec(int n, int *x, char *fname);

/* Read integer vector (don't convert to zero base indexing)*/
int *read_count_ivec(int n, char *fname);

/* Read docword file in sparse matrix format*/
void read_dw(char *fname, int *d, int *w, int *D, int *W); 

/* Read feasible nodes from file (or read a three-dimensional sparse matrix file)*/
//int*** read_feasible( char *fname, int *dim1, int *dim2, int *dim3, int size, int capacity, int **num_feasible);

/* Read a file with a variable number of integers per line */
int ** read_variable_line_i(char *file, int N, int M, int *num_per_line);

int ** read_line_i(char *file, int N, int num_per_line);

double ** read_line_d(char *file, int N, int num_per_line);

void read_dvec (int n, double *x, char *fname);

/* Write in sparse matrix format (convert to one base indexing)*/
void write_sparse(int nr, int nc, int **x, char *fname);

void write_sparse_d(int nr, int nc, double **x, char *fname);

/* Write double vector*/
void write_dvec(int n, double *x, char *fname);

/* Write integer vector (convert to one base indexing) */
void write_ivec(int n, int *x, char *fname);

/* Write integer vector (keep zero base indexing) */
void write_count_ivec( int n, int *x, char *fname);

/* Write a file with variable no. of integers per line */
void write_variable_line_i( char *file,  int **matrix, int *line_length, int num_lines);

/* Print out lp from each of the nodes in the graph*/
void print_lp(Graph *graph, int W, char *file);

/* Print out the permutation of the nodes for each stick-breaking distribution */
void print_perm(Graph *graph, char *perm_file);

/* Output the entire filename */
char *create_filename(char *dir, char *file);

/* Print out path assignment for each word token */
void print_paths(int num_paths, int *path_lengths, int **paths, char *file);

void print_cp(Graph *graph, int W, int L, char *file);

/* Print out state of Gibbs sampler */
void print_state(int iter, int ntot, int D, int W, int L, char *dir, int **paths, int *path_lengths, double *pi_d, int *levels, Graph *graph);



#endif
