/*---------------------------------------------------
 * File:    init.h
 * purpose: header file for initialization routines
 * author:  ahollowa@uci.edu
 * date:    12/22/2009
 *-------------------------------------------------*/

#ifndef _INIT_H_
#define _INIT_H_

#include "graph.h"

/* Random permutation of integers 0...n */
int *randperm(int n);

/* Initializes to a full graph */
void randomassignment_graph(int K, int L, int D, int W, int ntot, int *w, int *d, int **paths, int *path_lengths, int *levels, int *sum_levels, int ***dwl, int **dl, int *min_depth, double *pi_d, Graph *graph, int *docconcept);

/* Initialize gibbs sampling chain. Every path is initialized to the root node. */
void randomassignment(int L, int D, int W, int ntot, int *w, int *d, int **paths, int *path_lengths, int *levels, int *sum_levels, int ***dwl, int **dl, int *min_depth, double *pi_d, Graph *graph, int *docconcept);

/* Initialize gibbs sampling chain. Every path ends at docconcept unless FREE_PATH. Then it ends at root node */
void randomassignment_no_edges(int L, int D, int W, int ntot, int *w, int *d, int **paths, int *path_lengths, int *levels, int *sum_levels, int ***dwl, int **dl, int *min_depth, int *docconcept, double *pi_d, Graph *graph);

/* Initializes to a chain of depth L */
void randomassignment_chain(int L, int D, int W, int ntot, int *w, int *d, int **paths, int *path_lengths, int *levels, int *sum_levels, int ***dwl, int **dl, int *min_depth, double *pi_d, Graph *graph, int *docconcept);

#endif
