clear;

fontsize       = 10;
golden_ratio   = (sqrt(5)-1.0)/2.0;
fig_width      = 10;
fig_height     = 2.7;
subplot_width  = 2.9;
subplot_height = golden_ratio*subplot_width;
subplot_pos    = [0 0.12 subplot_width/fig_width subplot_height/fig_height];
format_string  = 'x%0.1e   ';

expt_names   = {'ionosphere', 'synthetic', 'mining', 'redwoods'};
%method_names = {'fixed', 'prior-white', 'surr-site', 'post-site', 'surr-taylor', 'post-taylor', 'surr-sigvar'};
method_names = {'fixed', 'prior-white', 'surr-site', 'post-site', 'surr-taylor', 'post-taylor'};

num_expts    = length(expt_names);
num_runs     = 10;
num_methods  = length(method_names);

llh_calls = zeros([num_expts num_runs num_methods]);
cov_calls = zeros([num_expts num_runs num_methods]);
effcomp   = zeros([num_expts num_runs num_methods]);
effcond   = zeros([num_expts num_runs num_methods]);
elapsed   = zeros([num_expts num_runs num_methods]);

%%%%%%%%% ionosphere %%%%%%%%%
expt_index             = 1;
setup                  = setup_ionosphere();
runs                   = setup.runs;
ionosphere_simple      = load('results/ionosphere_simple.mat');
ionosphere_chol        = load('results/ionosphere_chol.mat');
ionosphere_surr_noise  = load('results/ionosphere_surr_noise.mat');
ionosphere_fixed_noise = load('results/ionosphere_fixed_noise.mat');
%ionosphere_surr_gain   = load('results/ionosphere_surr_gain.mat');

for run=1:runs
  llh_calls(expt_index,run,1) = sum(ionosphere_simple.results(run).num_llh_calls);
  llh_calls(expt_index,run,2) = sum(ionosphere_chol.results(run).num_llh_calls);
  llh_calls(expt_index,run,3) = sum(ionosphere_surr_noise.results(run).num_llh_calls);
  llh_calls(expt_index,run,4) = sum(ionosphere_fixed_noise.results(run).num_llh_calls);
  %llh_calls(expt_index,run,7) = sum(ionosphere_surr_gain.results(run).num_llh_calls);
 
  cov_calls(expt_index,run,1) = sum(ionosphere_simple.results(run).num_cov_calls);
  cov_calls(expt_index,run,2) = sum(ionosphere_chol.results(run).num_cov_calls);
  cov_calls(expt_index,run,3) = sum(ionosphere_surr_noise.results(run).num_cov_calls);
  cov_calls(expt_index,run,4) = sum(ionosphere_fixed_noise.results(run).num_cov_calls);
  %cov_calls(expt_index,run,7) = sum(ionosphere_surr_gain.results(run).num_cov_calls);
 
  effcomp(expt_index,run,1) = ionosphere_simple.results(run).eff_comp_llh_samples;
  effcomp(expt_index,run,2) = ionosphere_chol.results(run).eff_comp_llh_samples;
  effcomp(expt_index,run,3) = ionosphere_surr_noise.results(run).eff_comp_llh_samples;
  effcomp(expt_index,run,4) = ionosphere_fixed_noise.results(run).eff_comp_llh_samples;
  %effcomp(expt_index,run,7) = ionosphere_surr_gain.results(run).eff_comp_llh_samples;
 
  effcond(expt_index,run,1) = ionosphere_simple.results(run).eff_cond_llh_samples;
  effcond(expt_index,run,2) = ionosphere_chol.results(run).eff_cond_llh_samples;
  effcond(expt_index,run,3) = ionosphere_surr_noise.results(run).eff_cond_llh_samples;
  effcond(expt_index,run,4) = ionosphere_fixed_noise.results(run).eff_cond_llh_samples;
  %effcond(expt_index,run,7) = ionosphere_surr_gain.results(run).eff_cond_llh_samples;
  
  elapsed(expt_index,run,1) = ionosphere_simple.results(run).elapsed;
  elapsed(expt_index,run,2) = ionosphere_chol.results(run).elapsed;
  elapsed(expt_index,run,3) = ionosphere_surr_noise.results(run).elapsed;
  elapsed(expt_index,run,4) = ionosphere_fixed_noise.results(run).elapsed;
  %elapsed(expt_index,run,7) = ionosphere_surr_gain.results(run).elapsed;
end

%%%%%%%%% gaussian %%%%%%%%%
expt_index            = 2;
setup                 = setup_gaussian();
runs                  = setup.runs; 
gaussian_simple       = load('results/gaussian_simple.mat');
gaussian_chol         = load('results/gaussian_chol.mat');
gaussian_surr_noise   = load('results/gaussian_surr_noise.mat');
gaussian_fixed_taylor = load('results/gaussian_fixed_taylor.mat');

for run=1:runs
  llh_calls(expt_index,run,1) = sum(gaussian_simple.results(run).num_llh_calls);
  llh_calls(expt_index,run,2) = sum(gaussian_chol.results(run).num_llh_calls);
  llh_calls(expt_index,run,3) = sum(gaussian_surr_noise.results(run).num_llh_calls);
  llh_calls(expt_index,run,4) = sum(gaussian_fixed_taylor.results(run).num_llh_calls);
  llh_calls(expt_index,run,5) = sum(gaussian_surr_noise.results(run).num_llh_calls);
  llh_calls(expt_index,run,6) = sum(gaussian_fixed_taylor.results(run).num_llh_calls);
 
  cov_calls(expt_index,run,1) = sum(gaussian_simple.results(run).num_cov_calls);
  cov_calls(expt_index,run,2) = sum(gaussian_chol.results(run).num_cov_calls);
  cov_calls(expt_index,run,3) = sum(gaussian_surr_noise.results(run).num_cov_calls);
  cov_calls(expt_index,run,4) = sum(gaussian_fixed_taylor.results(run).num_cov_calls);
  cov_calls(expt_index,run,5) = sum(gaussian_surr_noise.results(run).num_cov_calls);
  cov_calls(expt_index,run,6) = sum(gaussian_fixed_taylor.results(run).num_cov_calls);
 
  effcomp(expt_index,run,1) = gaussian_simple.results(run).eff_comp_llh_samples;
  effcomp(expt_index,run,2) = gaussian_chol.results(run).eff_comp_llh_samples;
  effcomp(expt_index,run,3) = gaussian_surr_noise.results(run).eff_comp_llh_samples;
  effcomp(expt_index,run,4) = gaussian_fixed_taylor.results(run).eff_comp_llh_samples;
  effcomp(expt_index,run,5) = gaussian_surr_noise.results(run).eff_comp_llh_samples;
  effcomp(expt_index,run,6) = gaussian_fixed_taylor.results(run).eff_comp_llh_samples;
 
  effcond(expt_index,run,1) = gaussian_simple.results(run).eff_cond_llh_samples;
  effcond(expt_index,run,2) = gaussian_chol.results(run).eff_cond_llh_samples;
  effcond(expt_index,run,3) = gaussian_surr_noise.results(run).eff_cond_llh_samples;
  effcond(expt_index,run,4) = gaussian_fixed_taylor.results(run).eff_cond_llh_samples;
  effcond(expt_index,run,5) = gaussian_surr_noise.results(run).eff_cond_llh_samples;
  effcond(expt_index,run,6) = gaussian_fixed_taylor.results(run).eff_cond_llh_samples;
  
  elapsed(expt_index,run,1) = gaussian_simple.results(run).elapsed;
  elapsed(expt_index,run,2) = gaussian_chol.results(run).elapsed;
  elapsed(expt_index,run,3) = gaussian_surr_noise.results(run).elapsed;
  elapsed(expt_index,run,4) = gaussian_fixed_taylor.results(run).elapsed;
  elapsed(expt_index,run,5) = gaussian_surr_noise.results(run).elapsed;
  elapsed(expt_index,run,6) = gaussian_fixed_taylor.results(run).elapsed;
end

%%%%%%%%% mine %%%%%%%%%
expt_index        = 3;
setup             = setup_mine();
runs              = setup.runs;
mine_simple       = load('results/mine_simple.mat');
mine_chol         = load('results/mine_chol.mat');
mine_surr_noise   = load('results/mine_surr_noise.mat');
mine_fixed_noise  = load('results/mine_fixed_noise.mat');
mine_surr_taylor  = load('results/mine_surr_taylor.mat');
mine_fixed_taylor = load('results/mine_fixed_taylor.mat');

for run=1:runs
  llh_calls(expt_index,run,1) = sum(mine_simple.results(run).num_llh_calls);
  llh_calls(expt_index,run,2) = sum(mine_chol.results(run).num_llh_calls);
  llh_calls(expt_index,run,3) = sum(mine_surr_noise.results(run).num_llh_calls);
  llh_calls(expt_index,run,4) = sum(mine_fixed_noise.results(run).num_llh_calls);
  llh_calls(expt_index,run,5) = sum(mine_surr_taylor.results(run).num_llh_calls);
  llh_calls(expt_index,run,6) = sum(mine_fixed_taylor.results(run).num_llh_calls);
 
  cov_calls(expt_index,run,1) = sum(mine_simple.results(run).num_cov_calls);
  cov_calls(expt_index,run,2) = sum(mine_chol.results(run).num_cov_calls);
  cov_calls(expt_index,run,3) = sum(mine_surr_noise.results(run).num_cov_calls);
  cov_calls(expt_index,run,4) = sum(mine_fixed_noise.results(run).num_cov_calls); 
  cov_calls(expt_index,run,5) = sum(mine_surr_taylor.results(run).num_cov_calls);
  cov_calls(expt_index,run,6) = sum(mine_fixed_taylor.results(run).num_cov_calls);
 
  effcomp(expt_index,run,1) = mine_simple.results(run).eff_comp_llh_samples;
  effcomp(expt_index,run,2) = mine_chol.results(run).eff_comp_llh_samples;
  effcomp(expt_index,run,3) = mine_surr_noise.results(run).eff_comp_llh_samples;
  effcomp(expt_index,run,4) = mine_fixed_noise.results(run).eff_comp_llh_samples;
  effcomp(expt_index,run,5) = mine_surr_taylor.results(run).eff_comp_llh_samples;
  effcomp(expt_index,run,6) = mine_fixed_taylor.results(run).eff_comp_llh_samples;
 
  effcond(expt_index,run,1) = mine_simple.results(run).eff_cond_llh_samples;
  effcond(expt_index,run,2) = mine_chol.results(run).eff_cond_llh_samples;
  effcond(expt_index,run,3) = mine_surr_noise.results(run).eff_cond_llh_samples;
  effcond(expt_index,run,4) = mine_fixed_noise.results(run).eff_cond_llh_samples;
  effcond(expt_index,run,5) = mine_surr_taylor.results(run).eff_cond_llh_samples;
  effcond(expt_index,run,6) = mine_fixed_taylor.results(run).eff_cond_llh_samples;
  
  elapsed(expt_index,run,1) = mine_simple.results(run).elapsed;
  elapsed(expt_index,run,2) = mine_chol.results(run).elapsed;
  elapsed(expt_index,run,3) = mine_surr_noise.results(run).elapsed;
  elapsed(expt_index,run,4) = mine_fixed_noise.results(run).elapsed;
  elapsed(expt_index,run,5) = mine_surr_taylor.results(run).elapsed;
  elapsed(expt_index,run,6) = mine_fixed_taylor.results(run).elapsed;
end

%%%%%%%%% redwood %%%%%%%%%
expt_index           = 4;
setup                = setup_redwood();
runs                 = setup.runs;
redwood_simple       = load('results/redwood_simple.mat');
redwood_chol         = load('results/redwood_chol.mat');
redwood_surr_noise   = load('results/redwood_surr_noise.mat');
redwood_fixed_noise  = load('results/redwood_fixed_noise.mat');
redwood_surr_taylor  = load('results/redwood_surr_taylor.mat');
redwood_fixed_taylor = load('results/redwood_fixed_taylor.mat');

for run=1:runs
  llh_calls(expt_index,run,1) = sum(redwood_simple.results(run).num_llh_calls);
  llh_calls(expt_index,run,2) = sum(redwood_chol.results(run).num_llh_calls);
  llh_calls(expt_index,run,3) = sum(redwood_surr_noise.results(run).num_llh_calls);
  llh_calls(expt_index,run,4) = sum(redwood_fixed_noise.results(run).num_llh_calls);
  llh_calls(expt_index,run,5) = sum(redwood_surr_taylor.results(run).num_llh_calls);
  llh_calls(expt_index,run,6) = sum(redwood_fixed_taylor.results(run).num_llh_calls);
 
  cov_calls(expt_index,run,1) = sum(redwood_simple.results(run).num_cov_calls);
  cov_calls(expt_index,run,2) = sum(redwood_chol.results(run).num_cov_calls);
  cov_calls(expt_index,run,3) = sum(redwood_surr_noise.results(run).num_cov_calls);
  cov_calls(expt_index,run,4) = sum(redwood_fixed_noise.results(run).num_cov_calls); 
  cov_calls(expt_index,run,5) = sum(redwood_surr_taylor.results(run).num_cov_calls);
  cov_calls(expt_index,run,6) = sum(redwood_fixed_taylor.results(run).num_cov_calls);
 
  effcomp(expt_index,run,1) = redwood_simple.results(run).eff_comp_llh_samples;
  effcomp(expt_index,run,2) = redwood_chol.results(run).eff_comp_llh_samples;
  effcomp(expt_index,run,3) = redwood_surr_noise.results(run).eff_comp_llh_samples;
  effcomp(expt_index,run,4) = redwood_fixed_noise.results(run).eff_comp_llh_samples;
  effcomp(expt_index,run,5) = redwood_surr_taylor.results(run).eff_comp_llh_samples;
  effcomp(expt_index,run,6) = redwood_fixed_taylor.results(run).eff_comp_llh_samples;
 
  effcond(expt_index,run,1) = redwood_simple.results(run).eff_cond_llh_samples;
  effcond(expt_index,run,2) = redwood_chol.results(run).eff_cond_llh_samples;
  effcond(expt_index,run,3) = redwood_surr_noise.results(run).eff_cond_llh_samples;
  effcond(expt_index,run,4) = redwood_fixed_noise.results(run).eff_cond_llh_samples;
  effcond(expt_index,run,5) = redwood_surr_taylor.results(run).eff_cond_llh_samples;
  effcond(expt_index,run,6) = redwood_fixed_taylor.results(run).eff_cond_llh_samples;
  
  elapsed(expt_index,run,1) = redwood_simple.results(run).elapsed;
  elapsed(expt_index,run,2) = redwood_chol.results(run).elapsed;
  elapsed(expt_index,run,3) = redwood_surr_noise.results(run).elapsed;
  elapsed(expt_index,run,4) = redwood_fixed_noise.results(run).elapsed;
  elapsed(expt_index,run,5) = redwood_surr_taylor.results(run).elapsed;
  elapsed(expt_index,run,6) = redwood_fixed_taylor.results(run).elapsed;
end

%%%%%%%%%% compllh per llh %%%%%%%%%%%
set(0, 'DefaultTextInterpreter', 'tex', ...
       'DefaultTextFontName',    'Helvetica', ...
       'DefaultTextFontSize',    fontsize, ...
       'DefaultAxesFontName',    'Helvetica', ...
       'DefaultAxesFontSize',    fontsize);
figure('Units', 'inches', ...
  'Position', [0 0 fig_width fig_height], ...
  'PaperPositionMode', 'auto');

offx = 0.06;
subplot('Position', subplot_pos + [offx 0 0 0]);
measure = effcomp ./ llh_calls;
means   = squeeze(mean(measure,2));
stds    = sqrt(squeeze(mean(measure.^2,2) - mean(measure,2).^2));
scales  = repmat(means(:,3), [1 num_methods]);
b = bar([1:num_expts], means./scales);
c = get(b, 'Children');

xdata = zeros([num_methods*4 1]);
ydata = zeros([num_methods*4 1]);
idx = 1;
for i = 1:length(c)
  xdata_i = mean(get(c{i}, 'xdata'));
  tmp_y   = get(c{i}, 'ydata');
  ydata_i = mean(tmp_y(2:3,:));
  for j = 1:4
    xdata(idx) = xdata_i(j);
    ydata(idx) = ydata_i(j);
        
    idx = idx + 1;
  end
end
hold on;
errorbar(xdata, ydata, stds(:)./(sqrt(num_runs)*scales(:)), 'k.');
hold off;
set(gca, 'XTickLabel', expt_names);
set(gca, 'Box', 'off');
xlim([0.5 4.5]);
%ylim([0 2]);
%ylabel('Effective samples');
title('Effective samples per likelihood evaluation');
for j = 1:4
  [figx figy] = dsxy2figxy(j, 0);
  ann = annotation('textbox',  [figx 0.01 0.01 0.01], ...
    'FitBoxToText', 'on', ...
    'LineStyle', 'none', ...
    'HorizontalAlignment', 'center', ...
    'FontSize', fontsize, ...
    'VerticalAlignment', 'baseline', ...
    'Margin', 0, ...
    'String', sprintf(format_string, scales(j,1)));
end


offx = offx + 0.32;
subplot('Position', subplot_pos + [offx 0 0 0]);
measure = effcomp ./ cov_calls;
means   = squeeze(mean(measure,2));
stds    = sqrt(squeeze(mean(measure.^2,2) - mean(measure,2).^2));
scales  = repmat(means(:,3), [1 num_methods]);
b     = bar([1:num_expts], means./scales);
c     = get(b, 'Children');

xdata = zeros([num_methods*4 1]);
ydata = zeros([num_methods*4 1]);
idx = 1;
for i = 1:length(c)
  xdata_i = mean(get(c{i}, 'xdata'));
  tmp_y   = get(c{i}, 'ydata');
  ydata_i = mean(tmp_y(2:3,:));
  for j = 1:4
    xdata(idx) = xdata_i(j);
    ydata(idx) = ydata_i(j);
    idx = idx + 1;
  end
end
hold on;
errorbar(xdata, ydata, stds(:)./(sqrt(num_runs)*scales(:)), 'k.');
hold off;
set(gca, 'XTickLabel', expt_names);
set(gca, 'Box', 'off');
xlim([0.5 4.5]);
%ylim([0 2]);
title('Effective samples per covariance construction');
for j = 1:4
  [figx figy] = dsxy2figxy(j, 0);
  ann = annotation('textbox',  [figx 0.01 0.01 0.01], ...
    'FitBoxToText', 'on', ...
    'LineStyle', 'none', ...
    'HorizontalAlignment', 'center', ...
    'FontSize', fontsize, ...
    'VerticalAlignment', 'baseline', ...
    'Margin', 0, ...
    'String', sprintf(format_string, scales(j,1)));
end

hl = legend(method_names, 'location', 'NorthOutside', 'orientation', 'horizontal');
set(hl, 'position', [0.2 0.9, 0.6 0.1]);

offx = offx + 0.32;
subplot('Position', subplot_pos + [offx 0 0 0]);
measure = effcomp ./ elapsed;
means = squeeze(mean(measure,2));
stds  = sqrt(squeeze(mean(measure.^2,2) - mean(measure,2).^2));
scales = repmat(means(:,3), [1 num_methods]);
b     = bar([1:num_expts], means./scales);
c     = get(b, 'Children');

xdata = zeros([num_methods*4 1]);
ydata = zeros([num_methods*4 1]);
idx = 1;
for i = 1:length(c)
  xdata_i = mean(get(c{i}, 'xdata'));
  tmp_y   = get(c{i}, 'ydata');
  ydata_i = mean(tmp_y(2:3,:));
  for j = 1:4
    xdata(idx) = xdata_i(j);
    ydata(idx) = ydata_i(j);
    idx = idx + 1;
  end
end
hold on;
errorbar(xdata, ydata, stds(:)./(sqrt(num_runs)*scales(:)), 'k.');
hold off;
set(gca, 'XTickLabel', expt_names);
set(gca, 'Box', 'off');
xlim([0.5 4.5]);
%ylim([0 2]);
title('Effective samples per second');
for j = 1:4
  [figx figy] = dsxy2figxy(j, 0);
  ann = annotation('textbox',  [figx 0.01 0.01 0.01], ...
    'FitBoxToText', 'on', ...
    'LineStyle', 'none', ...
    'HorizontalAlignment', 'center', ...
    'FontSize', fontsize, ...
    'VerticalAlignment', 'baseline', ...
    'Margin', 0, ...
    'String', sprintf(format_string, scales(j,1)));
end

print(gcf, 'plots/effsamp_bars_all.eps', '-depsc');
close;



