function w = lambertw_approx(x)

% See Corless, R. M.; Gonnet, G. H.; Hare, D. E. G.; Jeffrey, D. J.; Knuth, D.
% E. (1996). "On the Lambert W function". Advances in Computational Mathematics
% 5: 329–359. doi:10.1007/BF02124750
%
% ...or Wikipedia which is where I really got this from(!)

w = log(1 + x); % my arbitrary initialization.

% Halley's method updates
iters = 2;
for ii = 1:iters
    expw = exp(w);
    w = w - (w.*expw - x) ./ (expw.*(w+1) - (w+2).*(w.*expw-x)./(2*w+2));
end
