function [X Y] = get_redwood_data(num_bins)
locs        = load('data/redwood.dat')';
edges       = linspace(0, 1, num_bins+1);
centers     = (edges(1:end-1) + edges(2:end))/2;
[tmp xbins] = histc(locs(:,1), edges);
[tmp ybins] = histc(locs(:,2), edges);

[x1 x2] = meshgrid(centers);
X = [x1(:) x2(:)];

Y = zeros(num_bins, num_bins);
for n=1:length(xbins)
  Y(xbins(n),ybins(n)) = Y(xbins(n),ybins(n)) +1;
end
Y = Y(:);

end