K = 10; % Cross-validation experiment with naive median predictor
num_runs = 30;
num_trials = 100;

[xx,yy] = read_forestfires();
N = size(xx, 2);

trial_scores = zeros(num_trials, 1);
for tt = 1:num_trials
    fprintf('trial %d / %d\r', tt, num_trials);
    
    scores = zeros(num_runs, 1);
    for run = 1:num_runs
        idx = randperm(N);
        xx = xx(:, idx);
        yy = yy(idx);
        batches = make_batched(yy', K);
        for bb = 1:K
            yyb = cell2mat(batches([1:bb-1,bb+1:K]));
            % Bootstrap resample:
            Nb = length(yyb);
            pred = median(yyb(ceil(rand(Nb, 1)*Nb)));
            scores(run) = scores(run) + mean(abs(batches{bb}-pred));
        end
        scores(run) = scores(run) / K;
    end
    trial_scores(tt) = mean(scores);
end
fprintf('\n');
disp(errorbar_str(mean(trial_scores), std(trial_scores)));
disp(errorbar_str(trial_scores));
hist(trial_scores);

% >> naive_pred
% 12.8372 +/- 0.0046
%
% SVM got 12.71 +/- 0.01
%
% Cheating with naive_pred gets:
% >> mean(abs(yy-median(yy)))
% ans = 12.83
