function DEFAULT(var_name, value);
%DEFAULT sets a variable to a default value if undefined or empty
%
%     DEFAULT('num_iters', 42);
%
% num_iters will have its previous value, or if it wasn't defined or was empty,
% num_iters will now be equal to 42.
%
% Inputs:
%     var_name string
%        value whatever

% Iain Murray, September 2009

if evalin('caller', ['~exist(''' var_name ''', ''var'') || isempty(' var_name ')']);
    assignin('caller', var_name, value)
end
