# NPS_NEURIPS

## Installation
Our code was tested with python 3.6
Use `pip install -r requirements.txt` to install all dependencies.



## MNIST Transformation Task

Run the following command from the `MNIST` folder.

```
sh run.sh seed
```
Expected output:
After a few epochs a complete segregation of rules should be observed in the following manner:
```
rotate_left : {0: 0, 1: 0, 2: 0, 3: 4981}
translate_up : {0: 0, 1: 4950, 2: 0, 3: 0}
rotate_right : {0: 0, 1: 0, 2: 5030, 3: 0}
translate_down : {0: 5039, 1: 0, 2: 0, 3: 0}

```

The above snippet indicates that rule number 3 is solely being used for the rotate left transformation, rule number 1 is being used for translate up, rule number 2 is being used for rotate right, and rule number 0 is being used for translate down. Hence a complete segregation is observed.



## Coordinate Arithmetic Task
Run the following command from the `coordinate_arithmetic` folder.
```
sh run.sh seed baseline

baseline = True for running baseline and False for running NPS

```

To reproduce the experiments in the paper:
```
sh run.sh 6 False
```

This script prints the assignment of rules to operations on the validation set after every epoch. A clear segregation can be observed after approximately 70-80 epochs. For some seeds it may take longer.

Example of clear segregation from the output logs:

```
Operation to Rule:
0 {0: 376, 1: 0, 2: 3, 3: 138}
1 {0: 0, 1: 408, 2: 3, 3: 95}
2 {0: 0, 1: 0, 2: 0, 3: 483}
3 {0: 0, 1: 0, 2: 397, 3: 97}
```

The above matrix shows the assignment of operations to rules. Each row indicates a unique operation and each column indicates a unique rule. Row 0 stands for X Addition, row 1 stands for Y addition, row 2 stands for X subtraction, and row 3 stands for Y subtraction. This script also prints the evaluation MSE and the best evaluation MSE after every epoch:

```
eval_loss:tensor(0.0198, device='cuda:0', grad_fn=<DivBackward0>)
best_eval_loss:tensor(0.0198, device='cuda:0', grad_fn=<DivBackward0>)
```





