# Introduction

Code for recreating figures and numbers from paper: "Double/Debiased Machine Learning for Dynamic Treatment Effects"

# Execution

To generate the paper figures run

```
./all_coverage.sh
```

This will produce a set of `.png` files that contain distributions of point estimates, distribution of standard error estimates,
coverage probabilities of confidence intervals (for both the estimated parameters and for a set of target counterfactual
policies).

The results for constant effects will be in the newly created folder:

`results/long_range_constant`

and the results for heterogeneous effects in the folder:

`results/long_range_hetero`

The code assumes Python 3 and requires the standard packages: statsmodels, numpy, scipy, scikit-learn, matplotlib. All can be pip installed.

To create the figure that contains the benchmark performance run the jupyter notebook: `high_dim_state_any_m_panel.ipynb`.

The jupyter notebook `high_dim_state_any_panel_hetero.ipynb` compares performance with benchmarks when there is effect heterogeneity.
