import numpy as np
import scipy.sparse as sp
import torch
import time
import random
import copy

from utils.tool import read_data, write_dic, dictionary, normalize, sparse_mx_to_torch_sparse_tensor
    

def encoding_test(train_dataset, test_dataset):
    
    """load test-graph and test-facts, and do the encoding on the test-graph"""
     
    
    print("Start to encoding test-graph and load test-facts for {}".format(test_dataset))
    
    t_start = time.time()
    
    path = "data"
    
    test_graph_path = "{}/{}/test/test-graph.txt".format(path, test_dataset)
    test_fact_path = "{}/{}/test/test-random-sample/test0.txt".format(path, test_dataset)
    train_path = "{}/{}/train/train.txt".format(path, test_dataset)
    valid_path = "{}/{}/train/valid.txt".format(path, test_dataset)
    train_triples = read_data(train_path)
    valid_triples = read_data(valid_path)
    triples_for_filter = set()
    for t in train_triples:
        triples_for_filter.add((t[0], t[1], t[2]))
    for t in valid_triples:
        triples_for_filter.add((t[0], t[1], t[2]))
        
    #these two paths are for loading
    relation_dic_path = "{}/{}/train/relation-dic.txt".format(path, train_dataset)
    type_dic_path = "{}/{}/train/type-dic.txt".format(path, train_dataset)   
    
    
    test_graph_triples = read_data(test_graph_path)
    test_fact_triples_with_label = read_data(test_fact_path)
    
    #load relation dic and type dic generated by training 
    f_relation_dic = open(relation_dic_path)
    relations = []
    for line in f_relation_dic:
        relation_new = line.strip().split("\t")[1]
        relations.append(relation_new)

    f_type_dic = open(type_dic_path)
    types = []
    for line in f_type_dic:
        type_new = line.strip().split("\t")[1]
        types.append(type_new)            
    

    all_triples_with_label = test_graph_triples + test_fact_triples_with_label
    for t in all_triples_with_label:
        if t[-1] != "0":
            triples_for_filter.add((t[0], t[1], t[2]))
            
    test_graph_real_triples = []
    test_graph_type_triples = []
    for triple in test_graph_triples:
        if triple[1] != "<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>":
            test_graph_real_triples.append(triple)
        else:
            test_graph_type_triples.append(triple)

    test_fact_real_triples_with_label = []
    test_fact_type_triples_with_label = []
    for triple in test_fact_triples_with_label:
        if triple[1] != "<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>":
            test_fact_real_triples_with_label.append(triple)
        else:
            test_fact_type_triples_with_label.append(triple)
    
    all_real_triples_with_label = []
    all_type_triples_with_label = []
    
    constant_set = set()
    for triple in all_triples_with_label:
        if triple[1] != "<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>":
            constant_set.add(triple[0])
            constant_set.add(triple[2])
            all_real_triples_with_label.append(triple)
        else:
            constant_set.add(triple[0])
            all_type_triples_with_label.append(triple)
    
    constants = list(constant_set)

    constant2index = dictionary(constants)
    relation2index = dictionary(relations)
    type2index = dictionary(types)
    
    print("time:",time.time()-t_start)
    #generate list of pairs for encoding
    pairs_for_constant = dict([(i,set()) for i in range(len(constants))])
    p_idx = 0
    print("Start to encode the graph")
    s_time = time.time()
    
    #collect related pairs for each constant    
    pairs = []
    pair_set = set()
    for triple in all_real_triples_with_label:
        sub_idx = constant2index[triple[0]]
        obj_idx = constant2index[triple[2]]
        if sub_idx < obj_idx:
            if (sub_idx, obj_idx) not in pair_set:
                pair_set.add((sub_idx, obj_idx))
                pairs.append((sub_idx, obj_idx))
        if sub_idx > obj_idx:
            if (obj_idx, sub_idx) not in pair_set:
                pair_set.add((obj_idx, sub_idx))
                pairs.append((obj_idx, sub_idx))
    for constant_idx in range(len(constants)):
        pairs.append((constant_idx, constant_idx))
        pair_set.add((constant_idx, constant_idx))  
    pair2index = dictionary(pairs)
    for pair in pairs:
        p_idx = pair2index[pair]
        c1 = pair[0]
        c2 = pair[1]
        pairs_for_constant[c1].add(p_idx)
        pairs_for_constant[c2].add(p_idx)
    
    #collect neighbors for each pair node
    
    pneighbors_for_pair = dict([(i,set()) for i in range(len(pairs))])
    for c_idx in range(len(constants)):
        pairs_c = set(pairs_for_constant[c_idx])
        #pair and n_pair would contain one common constant
        for pair in pairs_c:
            for n_pair in pairs_c:
                if pair != n_pair:
                    pneighbors_for_pair[pair].add(n_pair)     
                    
    #generate edge list
    
    edges = []

    for i in range(len(pairs)):
        pneighbors = pneighbors_for_pair[i]
        for pneighbor in pneighbors:
            edges.append([i, pneighbor])
            edges.append([pneighbor, i])    

    #write_dic(constant_dic_path, constants)
    #print(edges)
    return_list = []
    #each time only take one example
    
    i_count = 0
    print('{} true test triples'.format(len(test_fact_triples_with_label)))
    for triple in test_fact_triples_with_label:
        i_count += 1
        print('\rgenerating graph for {}-th example'.format(str(i_count)),end='')
        pairs_for_t = pairs           
        if triple[-1] == "1":
            edges_for_t = copy.deepcopy(edges)
            new_pair_set = copy.deepcopy(pair_set)
            new_pairs = []
            hits_true = copy.deepcopy(triple)
            hits1_candidates_for_t = []
            hits3_candidates_for_t = []
            candidates = []
            for candidate_no_filter in constants:
                if candidate_no_filter != triple[0]:
                    if (candidate_no_filter, triple[1], triple[2]) not in triples_for_filter:
                        candidates.append(candidate_no_filter)
            for candidate in random.sample(candidates, 50):
                sub_idx = constant2index[candidate]
                obj_idx = constant2index[triple[2]]
                if sub_idx < obj_idx:
                    if (sub_idx, obj_idx) not in new_pair_set:
                        new_pair_set.add((sub_idx, obj_idx))
                        new_pairs.append((sub_idx, obj_idx))
                if sub_idx > obj_idx:
                    if (obj_idx, sub_idx) not in new_pair_set:
                        new_pair_set.add((obj_idx, sub_idx))
                        new_pairs.append((obj_idx, sub_idx))
                hits1_candidates_for_t.append([candidate, triple[1], triple[2]])          

            candidates = []
            for candidate_no_filter in constants:
                if candidate_no_filter != triple[2]:
                    if (triple[0], triple[1], candidate_no_filter) not in triples_for_filter:
                        candidates.append(candidate_no_filter)
            for candidate in random.sample(candidates, 50):
                
                sub_idx = constant2index[triple[0]]
                obj_idx = constant2index[candidate]
                if sub_idx < obj_idx:
                    if (sub_idx, obj_idx) not in new_pair_set:
                        new_pair_set.add((sub_idx, obj_idx))
                        new_pairs.append((sub_idx, obj_idx))
                if sub_idx > obj_idx:
                    if (obj_idx, sub_idx) not in new_pair_set:
                        new_pair_set.add((obj_idx, sub_idx))
                        new_pairs.append((obj_idx, sub_idx))
                    hits3_candidates_for_t.append([triple[0], triple[1], candidate])
            new_pair2index = dictionary(pairs+new_pairs)               
            edge_set = set()
            for p in new_pairs:
                for n_p in (pairs+new_pairs):
                    if (p[0] ==n_p[0]) or (p[1] ==n_p[1]):
                        if (p != n_p):
                            if (p, n_p) not in edge_set and (n_p, p not in edge_set):
                                edges_for_t.append([new_pair2index[p], new_pair2index[n_p]])
                                edges_for_t.append([new_pair2index[n_p], new_pair2index[p]])
                                edge_set.add((p, n_p))
                                edge_set.add((n_p, p))
            
      

            
            def triple2index(triple_now):
                sub_idx = constant2index[triple_now[0]]
                relation_idx = relation2index[triple_now[1]]
                obj_idx = constant2index[triple_now[2]]
                if (sub_idx, obj_idx) in new_pair_set:
                    pair_idx = new_pair2index[(sub_idx, obj_idx)]
                    dim_idx = len(types) + relation_idx
                elif (obj_idx, sub_idx) in new_pair_set:
                    pair_idx = new_pair2index[(obj_idx, sub_idx)]
                    dim_idx = len(types) + len(relations) + relation_idx
                else:
                    print(triple_now, sub_idx, relation_idx, obj_idx)
                    print("wrong")
                return pair_idx, dim_idx

            
            

            hits1_candidates_for_t_idx = []
            hits3_candidates_for_t_idx = []
            
            for t in hits1_candidates_for_t:
                candidate = triple2index(t)
                hits1_candidates_for_t_idx.append(candidate)
            
            
            for t in hits3_candidates_for_t:
                candidate = triple2index(t)
                hits3_candidates_for_t_idx.append(candidate)

            hits_true = triple2index(hits_true)
            edges_for_t = np.array(edges_for_t)
            pairs_for_t = pairs + new_pairs
            pair2index_for_t = new_pair2index
            positive_flag = 1
            
            del new_pair_set
        else:
            def triple2index(triple_now):
                sub_idx = constant2index[triple_now[0]]
                relation_idx = relation2index[triple_now[1]]
                obj_idx = constant2index[triple_now[2]]
                if (sub_idx, obj_idx) in pair_set:
                    pair_idx = pair2index[(sub_idx, obj_idx)]
                    dim_idx = len(types) + relation_idx
                elif (obj_idx, sub_idx) in pair_set:
                    pair_idx = pair2index[(obj_idx, sub_idx)]
                    dim_idx = len(types) + len(relations) + relation_idx
                else:
                    print(triple_now, sub_idx, relation_idx, obj_idx)
                    print("wrong")
                return pair_idx, dim_idx
            hits_true = triple2index(triple)
            edges_for_t = copy.deepcopy(np.array(edges))
            pairs_for_t = pairs
            pair2index_for_t = pair2index
            positive_flag = 0
            hits1_candidates_for_t_idx, hits3_candidates_for_t_idx = [], []
        #print(edges_for_t)
        adj = sp.coo_matrix((np.ones(edges_for_t.shape[0]), (edges_for_t[:, 0], edges_for_t[:, 1])), shape=(len(pairs_for_t), len(pairs_for_t)), dtype=np.float32)
        adj = adj + adj.T.multiply(adj.T > adj) - adj.multiply(adj.T > adj)

        adj = normalize(adj + sp.eye(adj.shape[0]))
        adj = sparse_mx_to_torch_sparse_tensor(adj)
        del edges_for_t

        def initialize(test_graph_real_triples, test_graph_type_triples, test_fact_real_triples_with_label, test_fact_type_triples_with_label):

            labels = torch.zeros(len(pairs_for_t), len(types) + 2*len(relations))
            masks = torch.zeros(len(pairs_for_t),  len(types) + 2*len(relations))
            features = torch.zeros(len(pairs_for_t),  len(types) + 2*len(relations))

            #labels and masks are generated for all triples in test-facts (pos&neg)

            for triple in test_fact_type_triples_with_label:
                cons = triple[0]
                typ = triple[2]
                label = triple[3]
                pair_idx= pair2index_for_t[(constant2index[cons], constant2index[cons])]
                typ_idx = type2index[typ]
                if label == "1":
                    labels[pair_idx][typ_idx] = 1
                elif label == "0":
                    labels[pair_idx][typ_idx] = 0
                masks[pair_idx][typ_idx] = 1 

            for triple in test_fact_real_triples_with_label:
                sub = triple[0]
                rel = triple[1]
                obj = triple[2]
                label = triple[3]
                sub_idx = constant2index[sub]
                rel_idx = relation2index[rel]
                obj_idx = constant2index[obj]

                try:
                    pair_idx = pair2index_for_t[(sub_idx, obj_idx)]        
                except:
                    pair_idx = pair2index_for_t[(obj_idx, sub_idx)]
                    rel_idx = rel_idx + len(relations)
                if label == "1":
                    labels[pair_idx][len(types) + rel_idx] = 1
                elif label == "0":
                    labels[pair_idx][len(types) + rel_idx] = 0
                masks[pair_idx][len(types) + rel_idx] = 1 

            #features are generated for all triples in test-graph (pos&neg)

            for triple in test_graph_type_triples:
                cons = triple[0]
                typ = triple[2]
                pair_idx= pair2index_for_t[(constant2index[cons], constant2index[cons])]
                typ_idx = type2index[typ]
                features[pair_idx][typ_idx] = 1



            for triple in test_graph_real_triples:
                sub = triple[0]
                rel = triple[1]
                obj = triple[2]
                sub_idx = constant2index[sub]
                rel_idx = relation2index[rel]
                obj_idx = constant2index[obj]

                try:
                    pair_idx = pair2index_for_t[(sub_idx, obj_idx)]        
                except:
                    pair_idx = pair2index_for_t[(obj_idx, sub_idx)]
                    rel_idx = rel_idx + len(relations)
                features[pair_idx][len(types) + rel_idx] = 1



            features.requires_grad = True
            labels.requires_grad = False

            return features, labels, masks
        if triple[1] == '<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>':
            features, labels, masks = initialize(test_graph_real_triples, test_graph_type_triples, [], [triple])
        else:
            features, labels, masks = initialize(test_graph_real_triples, test_graph_type_triples, [triple], [])
        num_type = len(types)
        num_relation = len(relations)
        

        curr_return = adj, features, labels, masks, num_type, num_relation, constants, relations, types, pairs_for_t, positive_flag, hits_true, hits1_candidates_for_t_idx, hits3_candidates_for_t_idx
        return_list.append(curr_return)
    print("\n")
    print("Total time elapsed for encoding: {:.4f}s".format(time.time() - t_start))
    return return_list