# GBP
Scalable Graph Neural Networks via Bidirectional Propagation

## Requirements
- CUDA 10.1
- python 3.6.10
- pytorch 1.4.0
- GCC 5.4.0
- [cnpy](https://github.com/rogersce/cnpy)
- [swig-4.0.1] (https://github.com/swig/swig)

## Datasets

The `data` folder includes three benchmark datasets(Cora, Citeseer, Pubmed). 
Other datasets can be downloaded from [PPI](http://snap.stanford.edu/graphsage/), [Yelp](https://github.com/GraphSAINT/GraphSAINT), [Amazon2M](https://github.com/google-research/google-research/tree/master/cluster_gcn) and [Friendster](http://snap.stanford.edu/data/com-Friendster.html). We also provide code to convert datasets to our format (in `convert` folder).

## Compilation
```sh
make
```
## Running the code

Cora, Citeseer, Pubmed
```sh
sh transductive.sh
```
PPI, Yelp, Amazon2M
```sh
sh inductive.sh
```
Friendster 
```sh
sh friendster.sh
```
