import sys
import random
from agent import Agent
sys.path.append("..")

class Linear2StateAgent(Agent):

    def __init__(self, dic_agent_conf, dic_traffic_env_conf, dic_path, cnt_round):

        super(Linear2StateAgent, self).__init__(dic_agent_conf, dic_traffic_env_conf, dic_path)
        self.action = 0
        self.ctr = 0

    def choose_action(self, count, state):
        ''' choose the best action for current state '''

        cur_phase = state["cur_phase"][0] - 1
        if cur_phase < 0:
            return self.action

        feature = "lane_num_vehicle"
        all = sum(state[feature])
        green = sum(state[feature][cur_phase * 3:cur_phase * 3 + 3])
        density = green / all if all else 0

        self.ctr += 1
        self.action = 0
        if all <= 0 or density >= self.dic_agent_conf["ALPHA"] or state["time_this_phase"][0] < self.dic_agent_conf["MIN_GREEN"]:
            return self.action

        if self.dic_agent_conf["MODE"] == 0:
            ratio = random.random()
        else:
            cycle_time = self.dic_agent_conf["CYCLE_TIME"]
            if self.dic_agent_conf["MODE"] == 2:
                cycle_time = int(self.dic_agent_conf["CYCLE_TIME"] * all * 2 / self.dic_agent_conf["MAX_DENSITY"])
                if cycle_time < self.dic_agent_conf["MIN_GREEN"]:
                    cycle_time = self.dic_agent_conf["MIN_GREEN"]
            ratio = state["time_this_phase"][0] / cycle_time

        self.action = ratio > density

        return self.action
