#!/bin/bash

set -x -e -u -o pipefail
cd ..

if [ -z ${SAVE_DIR+x} ]; then 
    echo "no save dir"; 
    PARAM_SAVE_DIR=""
else 
    echo "save dir"
    PARAM_SAVE_DIR="--save-dir ${SAVE_DIR} --maximize-best-checkpoint-metric"
fi

VOCAB=25000
SPAN=${SPAN}
PATIENCE=8
DROPOUT=0.4
ENC_LAYERS=1
WARMUP=0

CUDA_VISIBLE_DEVICES=0 python train.py data-bin/phoenix2014T/sp${VOCAB} \
        --task translation_sign \
        --target-lang de \
        --max-tokens 4096 \
        --num-levels 1 \
        --src-lv0-body-feat-root i3d-features/span=${SPAN}_stride=2 \
        --multilv-args '{"span_lengths": [], "level_links": [], "stride": 2, "eye": true, "same_level_links": true, "symmetric": true}' \
        --arch transformer_sign \
        --encoder-embed-dim 1024 \
        --decoder-embed-dim 300 \
        --warmup-updates ${WARMUP} \
        --lr 1e-04 \
        --lr-shrink 0.5 \
        --lr-patience ${PATIENCE} \
        --lr-scheduler reduce_lr_on_plateau \
        --lr-mode max \
        --optimizer adam \
        --activation-fn gelu \
        --criterion label_smoothed_cross_entropy \
        --valid-subset test \
        --label-smoothing 0.1 \
        --weight-decay 0.0001 \
        --dropout ${DROPOUT} \
        --max-epoch 200 \
        --save-interval 1 \
        --eval-bleu \
        --eval-bleu-args '{"beam": 10, "max_len_a": 1.2, "max_len_b": 10}' \
        --eval-tokenized-bleu \
        --eval-bleu-remove-bpe sentencepiece \
	--eval-bleu-detok space \
        --best-checkpoint-metric bleu \
        --maximize-best-checkpoint-metric \
        --encoder-learned-pos \
        --decoder-learned-pos \
	--decoder-attention-heads 10 \
	--decoder-embed-path data-bin/phoenix2014T/sp${VOCAB}/emb \
        --encoder-layers ${ENC_LAYERS} \
        --no-epoch-checkpoints \
        --no-last-checkpoints \
        ${PARAM_SAVE_DIR}
