from PIL import Image
import os
import pickle
import random
from shutil import copyfile
from scipy import misc
import numpy as np


def resize_img_folder(in_dir, out_dir):
    print('Folder %s' % in_dir)

    for i in range(9):
        in_dir_, out_dir_ = '{}/{}'.format(in_dir, i), '{}/{}'.format(out_dir, i)

        if not os.path.exists(out_dir_):
            os.makedirs(out_dir_)

        for filename in os.listdir(in_dir_):
            im = Image.open(os.path.join(in_dir_, filename))

            # Convert grayscale images into 3 channels
            if im.mode != "RGB":
                im = im.convert(mode="RGB")

            im_resized = im.resize((size, size))
            # Get rid of extension (.jpg or other)
            filename = os.path.splitext(filename)[0]
            im_resized.save(os.path.join(out_dir_, filename + '.png'))
    return


if __name__ == '__main__':
    size = 32
    resize_img_folder(in_dir='raw_data/train', out_dir='neo_data/train')
    resize_img_folder(in_dir='raw_data/val', out_dir='neo_data/val')
