import torch
import matplotlib
import matplotlib.pyplot as plt
import numpy as np
import imageio

def plot_gif(before_project, after_project, arrow, boundary_list, name = '0'):
    def generate_one_frame(data, pred, arrow, boundary, xy_max = 2):

        fig, ax = plt.subplots(figsize=(10,10))
        
        circle1 = plt.Circle((0, 0), 2.0, color='r', fill=False)
        ax.add_artist(circle1)

        X, Y, U, V = zip(*[arrow])
        ax.quiver(X, Y, U, V, angles='xy', scale_units='xy', scale=1)

        ax.scatter(data[:,0], data[:,1], c = 'y')
        ax.scatter(pred[:,0], pred[:,1], c = 'b')       
        ax.scatter(boundary[:,0], boundary[:,1], c = 'r')       
        ax.grid()
        ax.set(xlabel='X', ylabel='Y', title='yellow: points before projection; blue: after projection.')
        ax.set_xlim(-xy_max, xy_max)
        ax.set_ylim(-xy_max, xy_max)
        fig.canvas.draw()     

        image = np.frombuffer(fig.canvas.tostring_rgb(), dtype='uint8')
        image  = image.reshape(fig.canvas.get_width_height()[::-1] + (3,))
        
        return image
    
    imageio.mimsave('./visulization_' + name + '.gif', [
        generate_one_frame(before_project[i], after_project[i], arrow[i], boundary_list[i]) 
        for i in range(len(before_project))
        ], fps=10)

class Proj():
    def __init__(self):
        model_path = 'models/checkpoint _631.pt'
        self.model = torch.load(model_path).cpu()
        print(self.model.iter)
    def project(self, data):
        d = torch.Tensor(data[None, :, :])
        pred = self.model(d)
        pred = pred[0,:,:]
        return pred.detach().numpy()

def test(te = 0):
    data = np.array([[ 0.130514,   0.437662 ],
                        [ 0.0862001,  0.882675 ],
                        [ 0.575526,   0.481976 ],
                        [ 0.531213,   0.926988 ],
                        [-0.457831,  -0.12947  ],
                        [-0.5583,     0.306311 ],
                        [-0.0220487, -0.0290008],
                        [-0.122518,   0.406781 ]])
    timestamp = 0.1
    vel = np.array([[5.0, 0.0],[5.0, 0.0],[5.0, 0.0],[5.0, 0.0],
                    [5.0, 0.0],[5.0, 0.0],[5.0, 0.0],[5.0, 0.0]])
    if te == 0:
        force = lambda t: np.array([0.5, np.cos(t)]) * 0 
        g = np.array([0, -10])
    elif te == 1:
        force = lambda t: np.array([0.5, np.cos(t)]) * 0 
        g = np.array([0, -2])
        vel *= 0.2
    elif te == 2:
        force = lambda t: np.array([1, np.cos(t)]) * 10
        g = np.array([0, 0])

    data_list = []
    proj_list = []
    boundary_list = []
    force_list = []
    pr = Proj()
    for ite in range(200):
        new_data = np.array(data)
        boundary_data = np.array(data)
        f_3 = force(ite * timestamp)
        vel[3, :] += f_3 * timestamp
        for i in range (0, len(data)):
            vel[i, :] += timestamp * g
            new_data[i, :] = data[i,:] + vel[i,:] * timestamp 

        data_list.append(np.array(new_data))
        force_list.append(np.array([new_data[3,0], new_data[3,1], f_3[0]/50, f_3[1]/50]))

        new_data = pr.project(new_data) # new_data*0.5 + 0.5 * 

        # TAT
        center1 = (new_data[0,:]+new_data[1,:]+new_data[2,:]+new_data[3,:])/4
        center2 = (new_data[4,:]+new_data[5,:]+new_data[6,:]+new_data[7,:])/4
        boundary_data[0, :] = 0.6 * (new_data[3,:]-center1) - 1.2 * (new_data[1,:]-center1) + center1
        boundary_data[1, :] = 1.2 * (new_data[3,:]-center1) + 0.6 * (new_data[1,:]-center1) + center1
        boundary_data[2, :] = - 0.6 * (new_data[3,:]-center1) + 1.2 * (new_data[1,:]-center1) + center1
        boundary_data[3, :] = - 1.2 * (new_data[3,:]-center1) - 0.6 * (new_data[1,:]-center1) + center1
        boundary_data[4, :] = 0.6 * (new_data[7,:]-center2) - 1.2 * (new_data[5,:]-center2) + center2
        boundary_data[5, :] = 1.2 * (new_data[7,:]-center2) + 0.6 * (new_data[5,:]-center2) + center2
        boundary_data[6, :] = - 0.6 * (new_data[7,:]-center2) + 1.2 * (new_data[5,:]-center2) + center2
        boundary_data[7, :] = - 1.2 * (new_data[7,:]-center2) - 0.6 * (new_data[5,:]-center2) + center2

        proj_list.append(np.array(new_data))
        boundary_list.append(np.array(boundary_data))
        
        for i in range (len(data)):
           vel[i,:] =  (new_data[i,:] - data[i,:]) / timestamp # vel[i,:] * 0.5 + 0.5 *

        data = (np.array(new_data))
        # aaaaaaaaaaaaaaaaaaaa

    plot_gif(data_list, proj_list, force_list, boundary_list, str(te))




if __name__ == '__main__':
    test(0)
    test(1)
    # test(2)
