% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{sample_combinations}
\alias{sample_combinations}
\title{Helper function to sample a combination of training and testing rows, which does not risk
getting the same observation twice. Need to improve this help file.}
\usage{
sample_combinations(ntrain, ntest, nsamples, joint_sampling = TRUE)
}
\arguments{
\item{ntrain}{Positive integer. Number of training observations to sample from.}

\item{ntest}{Positive integer. Number of test observations to sample from.}

\item{nsamples}{Positive integer. Number of samples.}

\item{joint_sampling}{Logical. Indicates whether train- and test data should be sampled
separately or in a joint sampling space. If they are sampled separately (which typically
would be used when optimizing more than one distribution at once) we sample with replacement
if \code{nsamples > ntrain}. Note that this solution is not optimal. Be careful if you're
doing optimization over every test observation when \code{nsamples > ntrain}.}
}
\value{
data.frame
}
\description{
Helper function to sample a combination of training and testing rows, which does not risk
getting the same observation twice. Need to improve this help file.
}
\examples{
ntrain <- 10
ntest <- 10
nsamples <- 7
joint_sampling <- FALSE
cnms <- c("samp_train", "samp_test")
x <- shapr:::sample_combinations(ntrain, ntest, nsamples, joint_sampling)

}
\author{
Martin Jullum
}
\keyword{internal}
