% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mahalanobis_distance_cpp}
\alias{mahalanobis_distance_cpp}
\title{(Generalized) Mahalanobis distance}
\usage{
mahalanobis_distance_cpp(
  featureList,
  Xtrain_mat,
  Xtest_mat,
  mcov,
  S_scale_dist
)
}
\arguments{
\item{featureList}{List of vectors indicating all factor combinations that should be included in the computations. Assumes that the first one is empty.}

\item{Xtrain_mat}{Matrix}

\item{Xtest_mat}{Matrix}

\item{mcov}{Matrix. The Sigma-matrix in the Mahalanobis distance formula (\code{stats::cov(Xtrain_mat)}) gives Mahalanobis distance,
\code{diag(m)} gives the Euclidean distance.}

\item{S_scale_dist}{Logical indicating}
}
\value{
Array of three dimensions. Contains the squared distance for between all training and test observations for all feature combinations passed to the function.
}
\description{
Used to get the Euclidean distance as well by setting \code{mcov} = \code{diag(m)}.
}
\author{
Martin Jullum
}
