% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features.R
\name{feature_combinations}
\alias{feature_combinations}
\title{Define feature combinations, and fetch additional information about each unique combination}
\usage{
feature_combinations(
  m,
  exact = TRUE,
  n_combinations = 200,
  weight_zero_m = 10^6,
  asymmetric = FALSE,
  ordering = NULL
)
}
\arguments{
\item{m}{Positive integer. Total number of features.}

\item{exact}{Logical. If \code{TRUE} all \code{2^m} combinations are generated, otherwise a
subsample of the combinations is used.}

\item{n_combinations}{Positive integer. Note that if \code{exact = TRUE},
\code{n_combinations} is ignored. However, if \code{m > 12} you'll need to add a positive integer
value for \code{n_combinations}.}

\item{weight_zero_m}{Numeric. The value to use as a replacement for infinite combination
weights when doing numerical operations.}
}
\value{
A data.table that contains the following columns:
\describe{
\item{id_combination}{Positive integer. Represents a unique key for each combination. Note that the table
is sorted by \code{id_combination}, so that is always equal to \code{x[["id_combination"]] = 1:nrow(x)}.}
\item{features}{List. Each item of the list is an integer vector where \code{features[[i]]}
represents the indices of the features included in combination \code{i}. Note that all the items
are sorted such that \code{features[[i]] == sort(features[[i]])} is always true.}
\item{n_features}{Vector of positive integers. \code{n_features[i]} equals the number of features in combination
\code{i}, i.e. \code{n_features[i] = length(features[[i]])}.}.
\item{N}{Positive integer. The number of unique ways to sample \code{n_features[i]} features
from \code{m} different features, without replacement.}
}
}
\description{
Define feature combinations, and fetch additional information about each unique combination
}
\examples{
# All combinations
x <- shapr:::feature_combinations(m = 5)
nrow(x) # Equals 2^5 = 32

# Subsample of combinations
x <- shapr:::feature_combinations(m = 13, n_combinations = 1e3)
}
\author{
Nikolai Sellereite, Martin Jullum
}
\keyword{internal}
