SelectConsumerForOptimation <- function(experimentalSet, experimentParameters, treatmentSet){
  selectionProb <- experimentParameters$consumerForExposureMatchingProb
  experimentalSet <- experimentalSet %>% group_by(consumer) %>% mutate(selectedForOptimization = 
                                                 all(consumerInTreatment == 0) && 
                                                   sample(c(TRUE, FALSE), 1, prob = c(selectionProb, 1 - selectionProb))) %>% ungroup()
  
  # get true treatment level exposure
  cat("computing true treatment level exposure \n")
  experimentalSet <- split(experimentalSet, experimentalSet$producerInTreatment)
  experimentalSet <- lapply(1:length(experimentalSet), 
                            function(i) experimentalSet[[i]] %>% mutate(treatmentLevelExposure = unlist(experimentalSet[[i]][, treatmentSet[i]])))
  experimentalSet <- do.call("rbind", experimentalSet)
  
  # get experiment level exposure
  cat("computing experiment level exposure \n")
  experimentalSet$consumerInTreatment[is.na(experimentalSet$consumerInTreatment)] <- 0
  experimentalSet <- split(experimentalSet, experimentalSet$consumerInTreatment)
  experimentalSet <- lapply(1:length(experimentalSet), 
                            function(i) experimentalSet[[i]] %>% 
                              mutate(experimentLevelExposure = (!selectedForOptimization) * unlist(experimentalSet[[i]][, c("baseLevelExposure", treatmentSet)[i]])))
  experimentalSet <- do.call("rbind", experimentalSet)

  cat("Assigning optimization constraints \n")
  experimentalSet <- experimentalSet %>% group_by(producer) %>% 
    mutate(exposureDiff = sum(treatmentLevelExposure) - sum(experimentLevelExposure)) %>% 
    ungroup() 
  experimentalSet <- experimentalSet %>% group_by(consumer) %>% mutate(Aj = 1, 
                                                                       q = 1,
                                                                       totalBaseLevelExposure = sum(baseLevelExposure),
                                                                       lj = max(0, 1 - experimentParameters$SLim[2] * (1 - first(totalBaseLevelExposure))),
                                                                       uj = min(1, 1 - experimentParameters$SLim[1] * (1 - first(totalBaseLevelExposure))),
                                                                       lowerBound = experimentParameters$RLim[1] * baseLevelExposure,
                                                                       upperBound = experimentParameters$RLim[2] * baseLevelExposure) %>%
  ungroup() %>% select(-totalBaseLevelExposure)
  experimentalSet$upperBound[which(experimentalSet$upperBound > 1)] <- 1
  return(experimentalSet)
}