%% 
% Fig 17 in Sec C.4.2
% Momentum added to GD
% NAG-SC
% f_0=x^2/2
% f_1,eps=eps cos(x/eps)
%%
epsilon=0.0001;
xSpan=[-2:epsilon*0.1:2];
h=0.1;              % step size

xIC=[1:0.0001:2];   % distribution of initial ensemble
bins=[-2:0.1:2];    % bins for plot

TimeSteps=10000;    % number of steps for evolving the ensemble

%%
x=xIC; 

y=x;    % initial condition of y
    %   note NAG is supposed to work for only strongly convex functions; there is another version, NAG-C, that is designed for convex functions; either is initially designed for nonconvex functions, but people use them anyway
% mu is supposed to be the strong convexity constant of f
% but it is chosen to be the strong convexity constant of only f0 here
mu=1;
c=(1-sqrt(mu*h))/(1+sqrt(mu*h)); % parameter in NAG-SC

orbit=zeros(1,TimeSteps+1);
orbit(1)=x(1);
for i=1:TimeSteps
    
    % NAG-SC
    % a discrete version known as Nesterov Aaccelerated Gradient method for strongly convex function (NAG-SC); a reference: Yurii Nesterov. Introductory Lectures on Convex Optimization: A Basic Course, volume 87. Springer Science & Business Media, 2013
    y_=y;
    y=x-h*(x+sin(x/epsilon));
    x=y+c*(y-y_);

    orbit(i+1)=x(1);    % Take x(1) as an orbit and show the system is ergodic
end

%% plot the result
figure
histogram(xIC,bins,'Normalization','pdf');
hold on
histogram(x,bins,'Normalization','pdf');
title('\fontsize{32}hist of ensemble at final time');
set(gca,'FontSize',24);
xlabel('evolution of ensemble empirical distribution');
ylabel('pdf');
legend('initial distri.',['@ iteration #',num2str(TimeSteps)]);
set(gcf,'Position',[400 300 800 600]);

figure
histogram(orbit,bins,'Normalization','pdf');
set(gca,'FontSize',24);
ylim([0,1.8])
xlabel('x');
ylabel('pdf');
title(['\fontsize{32}hist of an orbit over time (IC=',num2str(orbit(1)),')']);
set(gcf,'Position',[400 300 800 600]);

figure
plot(orbit);
set(gca,'FontSize',24);
xlabel('# of iteration');
ylabel('x');
axis([0 TimeSteps -1 1]);
title(['\fontsize{32}one orbit (IC=',num2str(orbit(1)),')']);
set(gcf,'Position',[400 300 800 600]);

