%%
% Fig 7 in Sec C.1
% Observe the bifurcation in this system
% Run the system long enough to find orbit for each eta
% f_0=x^4/4
% f_1,eps=-eps(cos(x)/eps)

%%
solutionInterval = 1:1200;          % number of steps to let the system converge to its orbits (if exist)
etaRange = 0.0001:0.00001:0.0045;   % range of learning rate
x =ones(1,length(etaRange))*0.00123123213; % a randomly chosen but fixed initial condition 
index = 1;
epsilon=0.001;              % fixed epsilon to make sure the objective function is fixed
for eta = etaRange
    for n = solutionInterval
        x(n+1, index) = x(n, index)-eta*x(n, index).^3-eta*sin(x(n, index)/epsilon);    % convex but not strongly convex potential, evolving
    end
    index = index + 1;
end
cutOff = 1000; 
x = x(cutOff:end ,:);       % cut off the beginning steps that have not converge yet, only leave the steps on orbits (if exist)
%% plot the results
plot(etaRange/epsilon ,x,'k.','MarkerSize',1)
yline(pi*epsilon,'--r');    % boundary of local and global chaos
yline(-pi*epsilon,'--r');
ylabel('x-orbit');
xlabel('\eta/\epsilon');
xlim([0,max(etaRange)/epsilon]);
set(gca,'FontSize',16);
set(gcf,'Position',[400 300 800 600]);
