import os

os.environ['CUDA_VISIBLE_DEVICES'] = '0'
from train_vgg19 import vgg19
import torch
import torch.nn as nn
import torch.nn.functional as F
import torchvision.models as models
import torch.optim as optim
import numpy as np
from utils import Noisy,transform,random_label
noisy = Noisy.apply

import torchvision

from detect import l1_detection, untargeted_detection, targeted_detection

model = models.inception_v3(pretrained=True, transform_input=False)
model = torch.nn.DataParallel(model).cuda()
model.cuda()
model.eval()

real_adv = [None]*100

labs = np.load("/tmp/labs.npy")
for f in ["/tmp/adv.npy"]:#, "/tmp/2adv.npy", "/tmp/3adv.npy"]:
    print(f)
    
    for i,img in enumerate(np.load(f)):
        print(i)
        print(img.shape)
        timg = torch.tensor(img).cuda()
        l = model(transform(timg, dataset='imagenet')).argmax()
        if l != labs[i]:
#            c1 = np.max([l1_detection(model, timg, 'imagenet', 0.01) for _ in range(5)])
#            c2 = untargeted_detection(model, timg, 'imagenet', .005, 0.03, cap=25)
#            c3 = targeted_detection(model, timg, 'imagenet', .005, 0.03, cap=25)
#
#            print('  C1C', c1, '\t', c2, '\t', c3)
            real_adv[i] = img
        else:
            print("FAIL", i)
