#!/bin/bash
echo "script started"

opt=$1
lr=$2
k=$3
num_train=$4
seed_train=$5

root_dir=$HOME/scratch/neuralalgo/experiments/opt_learning/

phase=train

activation=relu
hidden_dim=20-20-20

epoch=50000
num_test=10000
seed=2
d=10
L=1
mu=0.1

filename=results_opt

dc=1e-4
batch=$((num_train / 2))


subdir=k-${k}-train-${num_train}-test-${num_test}-d-${d}-L-${L}-mu-${mu}-lr-${lr}-dc-${dc}-opt-${opt}-hidden-${hidden_dim}-act-${activation}-batch-${batch}-s-${seed_train}
echo "$subdir"
save_dir=$root_dir/../saved_loss/opt_learning/mlprnn/$subdir
algo_model_dump=$save_dir/best_train_algo.dump

if [ ! -e $save_dir ];
then
    mkdir -p $save_dir
fi

python3 main.py \
    -algo_type mlp_rnn \
    -seed $seed \
    -seed_train $seed_train \
    -d $d \
    -batch_size $batch \
    -save_dir $save_dir \
    -learning_rate $lr\
    -weight_decay $dc \
    -num_epochs $epoch \
    -k $k \
    -phase $phase \
    -L $L \
    -mu $mu \
    -num_train $num_train \
    -num_test $num_test \
    -model_dump $algo_model_dump \
    -optimizer $opt \
    -mlp_hidden_dims $hidden_dim \
    -activation $activation \
    -filename $filename
