#!/bin/bash
# Train structure-only model.

# SET HERE.
# Directory pdb dataset was extracted to.
PDB_DIR=
# Directory to output results to.
OUT_DIR=

if [ -z "$PDB_DIR" ] || [ -z $OUT_DIR ] 
then
    echo "Please specify parameters in train.sh first!"
    exit
fi

TRAIN_LIST=$PDB_DIR/ptt/heavy6/train.txt
TRAIN_SIZE=4
VAL_LIST=$PDB_DIR/ptt/heavy6/val.txt
VAL_SIZE=4

# Configure model params.
python main.py config interact model $OUT_DIR/model.json -l $OUT_DIR/model-config.log --num_filters --rad 1 --tower_fc_nodes

# Configure training run.
python main.py config interact train $PDB_DIR/ptt/heavy6 $TRAIN_SIZE $VAL_SIZE $OUT_DIR/train.json -l $OUT_DIR/train-config.log  --loose -b 4 -r 1 -g 1 --rolls-per-pass=1 -o RMS -lr 0.0001 --keep_file_training=$TRAIN_LIST --keep_file_validation=$VAL_LIST

# Run training.
python main.py interact $OUT_DIR/model.json $OUT_DIR/train.json $OUT_DIR -l $OUT_DIR/interact.log
