#!/bin/bash
# Test structure+sequence model.

# SET HERE.
# Directory db5 dataset was extracted to.
DB5_DIR=
# Directory to structure+sequence model was train at.
SEQMODEL_DIR=

if [ -z $SEQMODEL_DIR ] || [ -z $DB5_DIR ]
then
    echo "Please specify parameters in seq_test.sh first!"
    exit
fi

PSSM=$DB5_DIR/pssm/pssm.h5

LIST=$DB5_DIR/lists/DB5-update.txt
TEST_NAME=DB5-update-unbound-heavy6
SUBSEQMODEL_DIR=$SEQMODEL_DIR/$TEST_NAME
TEST_SIZE=4

# Configure prediction run.
python main.py config interact test $DB5_DIR/ptt/unbound_heavy6/ $TEST_SIZE $SUBSEQMODEL_DIR/test.json -l $SUBSEQMODEL_DIR/test-config.log -dir 20 -b 4 -r 20 -g 1 --keep_file_testing=$LIST --seq_src=$PSSM
cp $LIST $SUBSEQMODEL_DIR/list.txt

# Run prediction.
python main.py predict $SEQMODEL_DIR/model.json $SUBSEQMODEL_DIR/test.json $SEQMODEL_DIR $SUBSEQMODEL_DIR -q $SEQMODEL_DIR/seqmodel.json

# Eval per-complex AUC.
python scripts/eval.py $SEQMODEL_DIR
