import glob
import json
import os
import sys

import scripts.summarize_roc as sr


def summarize(model_dir):
    one_model_summary = {}
    for file in sorted(glob.glob(model_dir + '/*/roc.h5')):
        directory = os.path.dirname(file)
        test_name = os.path.basename(directory)
        if test_name == 'self':
            continue
        list = directory + '/list.txt'
        one_test_summary = sr.summarize(file, list)
        one_model_summary[test_name] = one_test_summary
    ls = sorted(glob.glob(model_dir + '/loss-summary*.json'))[-2]
    ls_data = json.load(open(ls, 'r'))
    one_model_summary['val_loss'] = ls_data['val_loss']
    return one_model_summary


if __name__ == '__main__':
    if len(sys.argv) < 2:
        print "Usage: python complex_auc.py MODEL_DIR"
        sys.exit(0)

    model_dir = sys.argv[1]
    one_model_summary = summarize(model_dir)
    print "Format is (ROC AUC/AVG PRE/ACC)"
    print "val loss: {:4.3f}".format(one_model_summary['val_loss'])
    for test_name, one_test_summary in one_model_summary.items():
        if test_name == 'val_loss':
            continue
        complex = one_test_summary[20]
        print ("{:<40} -- "
               "per-complex median: ({:4.3f}, {:4.3f}, {:4.3f}) "
               "all averaged: ({:4.3f}, {:4.3f}, {:4.3f}) "
               "all flat: ({:4.3f}, {:4.3f}, {:4.3f}) ".format(
                test_name,
                complex['median_mean_aucs'], complex['median_mean_aps'],
                complex['median_mean_accs'], complex['full_mean_aucs'],
                complex['full_mean_aps'], complex['full_mean_accs'],
                complex['full_aucs'], complex['full_aps'],
                complex['full_accs']))
