#include <algorithm>
#include <fstream>
#include <iostream>
#include <sstream>
#include "crowd.h"
#include "distro.h"
#include "infer.h"
#include "policy.h"
#include "sim.h"

#include <chrono>

using namespace std;

void test_all()
{
    distro_uniform_test();
    distro_beta_test();
    distro_dirac_test();
    distro_kronecker_test();
    distro_power_test();
    distro_exponential_test();
    distro_parse_test();

    crowd_budget_test();
    crowd_quota_test();
    crowd_workers_test();
    crowd_parse_test();

    infer_weighted_test();
    infer_majority_test();
    infer_acyclic_test();
    infer_delayed_test();
    infer_quick_test();
    infer_variational_test();
    infer_eigen_test();
    infer_montecarlo_test();
    infer_particle_test();
    infer_triangle_test();
    infer_parse_test();

    policy_uniform_test();
    policy_uncertainty_test();
    policy_parse_test();

    sim_budget_test();
    sim_error_test();
    sim_parse_test();

    cout << "Success!" << endl;
}

class params {
public:
    string file_name;
    unsigned int ran_seed;
    unsigned int n_sim_max;
    unsigned int n_sim_err_max;

    params(const char* file_name,
           unsigned int ran_seed,
           unsigned int n_sim_max,
           unsigned int n_sim_err_max):
        file_name(file_name),
        ran_seed(ran_seed),
        n_sim_max(n_sim_max),
        n_sim_err_max(n_sim_err_max)
    {};
};

params* params_parse(int *argc, char **argv[])
{
    if(*argc < 4) {
        cerr << "Not enough arguments to parse the params type" << endl;
        return NULL;
    }
    unsigned int ran_seed = strtoul((*argv)[1], NULL, 10);
    unsigned int n_sim_max = strtoul((*argv)[2], NULL, 10);
    unsigned int n_sim_err_max = strtoul((*argv)[3], NULL, 10);
    params* par = new params((*argv)[0], ran_seed, n_sim_max, n_sim_err_max);
    *argc -= 4; *argv += 4;
    return par;
}

/// list of parameters ///
// output file name
// random generator seed
// maximum number of simulations
// maximum number of simulations with errors
// simulation type {sim_budget, sim_error}
// simulation parameter
// inference type {infer_weighted, infer_majority, infer_acyclic}
// number of tasks
// inference parameters (optional)
// crowd type {crowd_budget, crowd_quota, crowd_workers}
// number of workers (optional)
// worker accuracy distribution with parameters
// worker quota distribution with parameters (optional)
// data collection policy

/// usage examples ///
// myfilename.csv 9999 1000 100 sim_budget 3 infer_weighted 10 crowd_budget 80085 dirac 0.666 kronecker 4 policy_uniform
// majority_t1000_b43_q100_uni_r15.csv 415 1000 1000 sim_budget 15 infer_majority 1000 0.6 crowd_budget 0 beta 4.0 3.0 kronecker 100 policy_uniform


int main(int argc, const char *argv[])
{
    lgammau_init();

    // test_all();/*

    int argc_bis = argc - 1;
    char** argv_bis = (char**) argv + 1;
    params* par = params_parse(&argc_bis, &argv_bis);

    mt19937 ran_gen = well_seeded_mt19937(par->ran_seed);

    ofstream out_file;
    out_file.open(par->file_name);

    unsigned int sim_err_count = 0;
    for(unsigned int h = 0; h < par->n_sim_max && sim_err_count < par->n_sim_err_max; ++h) {
        cout << "[" << (h + 1) << "] ";

        int argc_sim = argc_bis;
        char** argv_sim = argv_bis;
        sim* s = sim_parse(&argc_sim, &argv_sim);

        auto time_start = chrono::steady_clock::now(); // THIS
        s->run(ran_gen);
        auto time_end = chrono::steady_clock::now(); // THIS

        //double error_rate = s->inf->error_rate();
        //if(error_rate > 0.0)
            ++sim_err_count;

        //double error_pred = s->inf->error_predict();
        //out_file << error_rate << ", " << error_pred << endl;
        //cout << error_rate << ", " << error_pred << endl;

        //out_file << error_rate << endl;
        //cout << error_rate << endl;

        unsigned int time_total = chrono::duration_cast<chrono::milliseconds>(time_end - time_start).count();
        out_file << time_total << endl;
        cout << time_total << endl;

        delete s;
    }

    delete par;
    out_file.close();
    cout << "Finish!" << endl;

    // dummy comment*/
    return 0;
}

// command line example:
// binary_sims.exe trec.csv trec_stream.csv 1234 10 infer_acyclic 711 4.0 3.0

/*
int main(int argc, const char *argv[])
{
    lgammau_init();

    //test_all();/*

    const char *in_file = argv[1];
    const char *out_file = argv[2];
    unsigned int ran_seed = strtoul(argv[3], NULL, 10);
    unsigned int n_rep = strtoul(argv[4], NULL, 10);

    crowd_file cwd(in_file);
    mt19937 ran_gen = well_seeded_mt19937(ran_seed);

    int argc_bis = argc - 5;
    char** argv_bis = (char**) argv + 5;

    infer* inf = infer_parse(&argc_bis, &argv_bis);

    if(inf->task_odds.size() != cwd.n_tasks) {
        cerr << "The number of tasks in the file is " << cwd.n_tasks
             << " not " << inf->task_odds.size() << endl;
        return -1;
    }

    ofstream ofile;
    ofile.open(out_file);

    for(unsigned int h = 0; h < n_rep; ++h) {

        inf->infer_full(ran_gen, (crowd*) &cwd, cwd.n_labels - 1);
        double error_rate = inf->error_rate();

        ofile << error_rate << endl;
        cout << error_rate << endl;

        shuffle(cwd.data_seq.begin(), cwd.data_seq.end(), ran_gen);
    }

    ofile.close();
    delete inf;

    // dummy comment*/
//    return 0;
//}
