## Operator Schemas
*This file is automatically generated from the
            [def files](/onnx/defs) via [this script](/onnx/defs/gen_doc.py).
            Do not modify directly and instead edit operator definitions.*

* ai.onnx.ml
  * <a href="#ai.onnx.ml.ArrayFeatureExtractor">ai.onnx.ml.ArrayFeatureExtractor</a>
  * <a href="#ai.onnx.ml.Binarizer">ai.onnx.ml.Binarizer</a>
  * <a href="#ai.onnx.ml.CastMap">ai.onnx.ml.CastMap</a>
  * <a href="#ai.onnx.ml.CategoryMapper">ai.onnx.ml.CategoryMapper</a>
  * <a href="#ai.onnx.ml.DictVectorizer">ai.onnx.ml.DictVectorizer</a>
  * <a href="#ai.onnx.ml.FeatureVectorizer">ai.onnx.ml.FeatureVectorizer</a>
  * <a href="#ai.onnx.ml.Imputer">ai.onnx.ml.Imputer</a>
  * <a href="#ai.onnx.ml.LabelEncoder">ai.onnx.ml.LabelEncoder</a>
  * <a href="#ai.onnx.ml.LinearClassifier">ai.onnx.ml.LinearClassifier</a>
  * <a href="#ai.onnx.ml.LinearRegressor">ai.onnx.ml.LinearRegressor</a>
  * <a href="#ai.onnx.ml.Normalizer">ai.onnx.ml.Normalizer</a>
  * <a href="#ai.onnx.ml.OneHotEncoder">ai.onnx.ml.OneHotEncoder</a>
  * <a href="#ai.onnx.ml.SVMClassifier">ai.onnx.ml.SVMClassifier</a>
  * <a href="#ai.onnx.ml.SVMRegressor">ai.onnx.ml.SVMRegressor</a>
  * <a href="#ai.onnx.ml.Scaler">ai.onnx.ml.Scaler</a>
  * <a href="#ai.onnx.ml.TreeEnsembleClassifier">ai.onnx.ml.TreeEnsembleClassifier</a>
  * <a href="#ai.onnx.ml.TreeEnsembleRegressor">ai.onnx.ml.TreeEnsembleRegressor</a>
  * <a href="#ai.onnx.ml.ZipMap">ai.onnx.ml.ZipMap</a>

## ai.onnx.ml
### <a name="ai.onnx.ml.ArrayFeatureExtractor"></a><a name="ai.onnx.ml.arrayfeatureextractor">**ai.onnx.ml.ArrayFeatureExtractor**</a>

  Select a subset of the data X based on the indices provided Y.

#### Version

This version of the operator has been available since version 1 of the 'ai.onnx.ml' operator set.

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Data to be selected</dd>
<dt><tt>Y</tt> : tensor(int64)</dt>
<dd>The index values to select as a int64 tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Z</tt> : T</dt>
<dd>Selected output data as an array</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(double), tensor(int64), tensor(int32), tensor(string)</dt>
<dd>allowed types.</dd>
</dl>


### <a name="ai.onnx.ml.Binarizer"></a><a name="ai.onnx.ml.binarizer">**ai.onnx.ml.Binarizer**</a>

  Makes values 1 or 0 based on a single threshold.

#### Version

This version of the operator has been available since version 1 of the 'ai.onnx.ml' operator set.

#### Attributes

<dl>
<dt><tt>threshold</tt> : float</dt>
<dd>Values greater than this are set to 1, else set to 0</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Data to be binarized</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Binarized output data</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(double), tensor(int64), tensor(int32)</dt>
<dd>allowed types.</dd>
</dl>


### <a name="ai.onnx.ml.CastMap"></a><a name="ai.onnx.ml.castmap">**ai.onnx.ml.CastMap**</a>

  Converts a map to a tensor.  Map key must be int64 and the values will be ordered
      in ascending order based on this key.  Supports dense packing or sparse packing.
      If using sparse packing, the key cannot exceed the max_map-1 value.

#### Version

This version of the operator has been available since version 1 of the 'ai.onnx.ml' operator set.

#### Attributes

<dl>
<dt><tt>cast_to</tt> : string</dt>
<dd>what type of tensor to cast the input to, enum 'TO_FLOAT','TO_STRING','TO_INT64', default is 'TO_FLOAT'</dd>
<dt><tt>map_form</tt> : string</dt>
<dd>whether to only output as many values as are in the input, or position the input based on using the key of the map as the index of the output (sparse), enum 'DENSE', 'SPARSE', default is 'DENSE'</dd>
<dt><tt>max_map</tt> : int</dt>
<dd>if map_form packing is SPARSE, what is the total length of each output in N (max index value)</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T1</dt>
<dd>Data to be encoded</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T2</dt>
<dd>encoded output data</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : map(int64, string), map(int64, float)</dt>
<dd> allowed input types.</dd>
<dt><tt>T2</tt> : tensor(string), tensor(float), tensor(int64)</dt>
<dd> allowed output types.</dd>
</dl>


### <a name="ai.onnx.ml.CategoryMapper"></a><a name="ai.onnx.ml.categorymapper">**ai.onnx.ml.CategoryMapper**</a>

  Convert strings to int64s and vice versa.
      Takes in a map to use for the conversion.
      The index position in the strings and ints repeated inputs
       is used to do the mapping.
      Each instantiated operator converts either ints to strings or strings to ints.
      This behavior is triggered based on which default value is set.
      If the string default value is set, it will convert ints to strings.
      If the int default value is set, it will convert strings to ints.

#### Version

This version of the operator has been available since version 1 of the 'ai.onnx.ml' operator set.

#### Attributes

<dl>
<dt><tt>cats_int64s</tt> : list of ints</dt>
<dd>ints part of the input map, must be same size and the strings</dd>
<dt><tt>cats_strings</tt> : list of strings</dt>
<dd>strings part of the input map, must be same size and the ints</dd>
<dt><tt>default_int64</tt> : int</dt>
<dd>int value to use if the string is not in the map</dd>
<dt><tt>default_string</tt> : string</dt>
<dd>string value to use if the int is not in the map</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T1</dt>
<dd>Input data</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T2</dt>
<dd>Output data, if strings are input, then output is int64s, and vice versa.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(string), tensor(int64)</dt>
<dd> allowed types.</dd>
<dt><tt>T2</tt> : tensor(string), tensor(int64)</dt>
<dd> allowed types.</dd>
</dl>


### <a name="ai.onnx.ml.DictVectorizer"></a><a name="ai.onnx.ml.dictvectorizer">**ai.onnx.ml.DictVectorizer**</a>

  Uses an index mapping to convert a dictionary to an array.
      The output array will be equal in length to the index mapping vector parameter.
      All keys in the input dictionary must be present in the index mapping vector.
      For each item in the input dictionary, insert its value in the output array.
      The position of the insertion is determined by the position of the item's key
      in the index mapping. Any keys not present in the input dictionary, will be
      zero in the output array.  Use either string_vocabulary or int64_vocabulary, not both.
      For example: if the ``string_vocabulary`` parameter is set to ``["a", "c", "b", "z"]``,
      then an input of ``{"a": 4, "c": 8}`` will produce an output of ``[4, 8, 0, 0]``.
      

#### Version

This version of the operator has been available since version 1 of the 'ai.onnx.ml' operator set.

#### Attributes

<dl>
<dt><tt>int64_vocabulary</tt> : list of ints</dt>
<dd>The vocabulary vector</dd>
<dt><tt>string_vocabulary</tt> : list of strings</dt>
<dd>The vocabulary vector</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T1</dt>
<dd>The input dictionary</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T2</dt>
<dd>The tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : map(string, int64), map(int64, string), map(int64, float), map(int64, double), map(string, float), map(string, double)</dt>
<dd> allowed types.</dd>
<dt><tt>T2</tt> : tensor(int64), tensor(float), tensor(double), tensor(string)</dt>
<dd> allowed types.</dd>
</dl>


### <a name="ai.onnx.ml.FeatureVectorizer"></a><a name="ai.onnx.ml.featurevectorizer">**ai.onnx.ml.FeatureVectorizer**</a>

  Concatenates input features into one continuous output of floats.
      inputdimensions is the size of each input feature.
      Inputs will be written to the output in the order of the input arguments.
      If an input tensor is shorter than its matching input dimension the output will be padded with zeros.
      If an input tensor is longer than its matching input dimension, the additional input will be ignored.
      Input tensors must all be of the same type. Use Cast as needed.  
      Input tensors must all be of the same batch size.

#### Version

This version of the operator has been available since version 1 of the 'ai.onnx.ml' operator set.

#### Attributes

<dl>
<dt><tt>inputdimensions</tt> : list of ints</dt>
<dd>the size of each input in the input list</dd>
</dl>

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>X</tt> (variadic) : T1</dt>
<dd>ordered input tensors</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : tensor(float)</dt>
<dd>Output array, in same order as Input, as floats</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(int32), tensor(int64), tensor(float), tensor(double)</dt>
<dd> Allowed input types</dd>
</dl>


### <a name="ai.onnx.ml.Imputer"></a><a name="ai.onnx.ml.imputer">**ai.onnx.ml.Imputer**</a>

  Replace imputs that equal replaceValue/s  with  imputeValue/s.
      All other inputs are copied to the output unchanged.
      This op is used to replace missing values where we know what a missing value looks like.
      Only one of imputed_value_floats or imputed_value_int64s should be used.
      The size can be 1 element, which will be reused, or the size of the feature set F in input N,F

#### Version

This version of the operator has been available since version 1 of the 'ai.onnx.ml' operator set.

#### Attributes

<dl>
<dt><tt>imputed_value_floats</tt> : list of floats</dt>
<dd>value to change to</dd>
<dt><tt>imputed_value_int64s</tt> : list of ints</dt>
<dd>value to change to</dd>
<dt><tt>replaced_value_float</tt> : float</dt>
<dd>value that needs replacing</dd>
<dt><tt>replaced_value_int64</tt> : int</dt>
<dd>value that needs replacing</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Data to be imputed</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Imputed output data</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(double), tensor(int64), tensor(int32)</dt>
<dd> allowed types.</dd>
</dl>


### <a name="ai.onnx.ml.LabelEncoder"></a><a name="ai.onnx.ml.labelencoder">**ai.onnx.ml.LabelEncoder**</a>

  Convert class label to their integral type and vice versa.
      In both cases the operator is instantiated with the list of class strings.
      The integral value of the string is the index position in the list.

#### Version

This version of the operator has been available since version 1 of the 'ai.onnx.ml' operator set.

#### Attributes

<dl>
<dt><tt>classes_strings</tt> : list of strings</dt>
<dd>List of class label strings to be encoded as int64s</dd>
<dt><tt>default_int64</tt> : int</dt>
<dd>Default value if not in class list as int64</dd>
<dt><tt>default_string</tt> : string</dt>
<dd>Default value if not in class list as string</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T1</dt>
<dd>Data to be encoded</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T2</dt>
<dd>Encoded output data</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(string), tensor(int64)</dt>
<dd> allowed types.</dd>
<dt><tt>T2</tt> : tensor(string), tensor(int64)</dt>
<dd> allowed types.</dd>
</dl>


### <a name="ai.onnx.ml.LinearClassifier"></a><a name="ai.onnx.ml.linearclassifier">**ai.onnx.ml.LinearClassifier**</a>

  Linear classifier prediction (choose class)

#### Version

This version of the operator has been available since version 1 of the 'ai.onnx.ml' operator set.

#### Attributes

<dl>
<dt><tt>classlabels_ints</tt> : list of ints</dt>
<dd>class labels if using int labels</dd>
<dt><tt>classlabels_strings</tt> : list of strings</dt>
<dd>class labels if using string labels</dd>
<dt><tt>coefficients</tt> : list of floats (required)</dt>
<dd>weights of the model(s)</dd>
<dt><tt>intercepts</tt> : list of floats</dt>
<dd>weights of the intercepts (if used)</dd>
<dt><tt>multi_class</tt> : int</dt>
<dd>whether to do OvR or multinomial (0=OvR and is default)</dd>
<dt><tt>post_transform</tt> : string</dt>
<dd>enum NONE, SOFTMAX, LOGISTIC, SOFTMAX_ZERO, PROBIT</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T1</dt>
<dd>Data to be classified</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T2</dt>
<dd>Classification outputs (one class per example</dd>
<dt><tt>Z</tt> : tensor(float)</dt>
<dd>Classification scores (N,E - one score for each class, for each example</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float), tensor(double), tensor(int64), tensor(int32)</dt>
<dd> allowed types.</dd>
<dt><tt>T2</tt> : tensor(string), tensor(int64)</dt>
<dd> allowed types.</dd>
</dl>


### <a name="ai.onnx.ml.LinearRegressor"></a><a name="ai.onnx.ml.linearregressor">**ai.onnx.ml.LinearRegressor**</a>

  Generalized linear regression evaluation.
      If targets is set to 1 (default) then univariate regression is performed.
      If targets is set to M then M sets of coefficients must be passed in as a sequence
      and M results will be output for each input n in N.
      Coefficients are of the same length as an n, and coefficients for each target are contiguous.
      Intercepts are optional but if provided must match the number of targets.

#### Version

This version of the operator has been available since version 1 of the 'ai.onnx.ml' operator set.

#### Attributes

<dl>
<dt><tt>coefficients</tt> : list of floats</dt>
<dd>weights of the model(s)</dd>
<dt><tt>intercepts</tt> : list of floats</dt>
<dd>weights of the intercepts (if used)</dd>
<dt><tt>post_transform</tt> : string</dt>
<dd>enum NONE, SOFTMAX, LOGISTIC, SOFTMAX_ZERO, PROBIT</dd>
<dt><tt>targets</tt> : int</dt>
<dd>total number of regression targets (default is 1)</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Data to be regressed</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : tensor(float)</dt>
<dd>Regression outputs (one per target, per example</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(double), tensor(int64), tensor(int32)</dt>
<dd> allowed types.</dd>
</dl>


### <a name="ai.onnx.ml.Normalizer"></a><a name="ai.onnx.ml.normalizer">**ai.onnx.ml.Normalizer**</a>

  Normalize the input.  There are three normalization modes,
      which have the corresponding formulas:
      Max .. math::     max(x_i)
      L1  .. math::  z = ||x||_1 = \sum_{i=1}^{n} |x_i|
      L2  .. math::  z = ||x||_2 = \sqrt{\sum_{i=1}^{n} x_i^2}

#### Version

This version of the operator has been available since version 1 of the 'ai.onnx.ml' operator set.

#### Attributes

<dl>
<dt><tt>norm</tt> : string</dt>
<dd>enum 'MAX', 'L1', 'L2'</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Data to be encoded</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : tensor(float)</dt>
<dd>encoded output data</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(double), tensor(int64), tensor(int32)</dt>
<dd> allowed types.</dd>
</dl>


### <a name="ai.onnx.ml.OneHotEncoder"></a><a name="ai.onnx.ml.onehotencoder">**ai.onnx.ml.OneHotEncoder**</a>

  Replace the inputs with an array of ones and zeros, where the only
      one is the zero-based category that was passed in.  The total category count
      will determine the length of the vector. For example if we pass a
      tensor with a single value of 4, and a category count of 8, the
      output will be a tensor with 0,0,0,0,1,0,0,0 .
  
      This operator assumes every input in X is of the same category set
      (meaning there is only one category count).
  
      If the input is a tensor of float, int32, or double, the data will be cast
      to int64s and the cats_int64s category list will be used for the lookups.

#### Version

This version of the operator has been available since version 1 of the 'ai.onnx.ml' operator set.

#### Attributes

<dl>
<dt><tt>cats_int64s</tt> : list of ints</dt>
<dd>list of categories, ints</dd>
<dt><tt>cats_strings</tt> : list of strings</dt>
<dd>list of categories, strings</dd>
<dt><tt>zeros</tt> : int</dt>
<dd>if true and category is not present, will return all zeros, if false and missing category, operator will return false. Default is true (1).</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Data to be encoded</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : tensor(float)</dt>
<dd>encoded output data</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(string), tensor(int64), tensor(int32), tensor(float), tensor(double)</dt>
<dd> allowed types.</dd>
</dl>


### <a name="ai.onnx.ml.SVMClassifier"></a><a name="ai.onnx.ml.svmclassifier">**ai.onnx.ml.SVMClassifier**</a>

  SVM classifier prediction

#### Version

This version of the operator has been available since version 1 of the 'ai.onnx.ml' operator set.

#### Attributes

<dl>
<dt><tt>classlabels_ints</tt> : list of ints</dt>
<dd>class labels if using int labels</dd>
<dt><tt>classlabels_strings</tt> : list of strings</dt>
<dd>class labels if using string labels</dd>
<dt><tt>coefficients</tt> : list of floats</dt>
<dd></dd>
<dt><tt>kernel_params</tt> : list of floats</dt>
<dd>Tensor of 3 elements containing gamma, coef0, degree in that order.  Zero if unused for the kernel.</dd>
<dt><tt>kernel_type</tt> : string</dt>
<dd>enum LINEAR, POLY, RBF, SIGMOID, defaults to linear</dd>
<dt><tt>post_transform</tt> : string</dt>
<dd>post eval transform for score, enum NONE, SOFTMAX, LOGISTIC, SOFTMAX_ZERO, PROBIT</dd>
<dt><tt>prob_a</tt> : list of floats</dt>
<dd>First set of probability coefficients</dd>
<dt><tt>prob_b</tt> : list of floats</dt>
<dd>Second set of probability coefficients, must be same size as prob_a, if these are provided then output Z are probability estimates.</dd>
<dt><tt>rho</tt> : list of floats</dt>
<dd></dd>
<dt><tt>support_vectors</tt> : list of floats</dt>
<dd></dd>
<dt><tt>vectors_per_class</tt> : list of ints</dt>
<dd></dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T1</dt>
<dd>Data to be classified</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T2</dt>
<dd>Classification outputs (one class per example)</dd>
<dt><tt>Z</tt> : tensor(float)</dt>
<dd>Class scores (one per class per example), if prob_a and prob_b are provided they are probabilities for each class otherwise they are raw scores.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float), tensor(double), tensor(int64), tensor(int32)</dt>
<dd> allowed types.</dd>
<dt><tt>T2</tt> : tensor(string), tensor(int64)</dt>
<dd> allowed types.</dd>
</dl>


### <a name="ai.onnx.ml.SVMRegressor"></a><a name="ai.onnx.ml.svmregressor">**ai.onnx.ml.SVMRegressor**</a>

  SVM regression prediction and one-class svm anomaly detection

#### Version

This version of the operator has been available since version 1 of the 'ai.onnx.ml' operator set.

#### Attributes

<dl>
<dt><tt>coefficients</tt> : list of floats</dt>
<dd>support vector coefficients</dd>
<dt><tt>kernel_params</tt> : list of floats</dt>
<dd>Tensor of 3 elements containing gamma, coef0, degree in that order.  Zero if unused for the kernel.</dd>
<dt><tt>kernel_type</tt> : string</dt>
<dd>enum LINEAR, POLY, RBF, SIGMOID, defaults to linear</dd>
<dt><tt>n_supports</tt> : int</dt>
<dd>number of support vectors</dd>
<dt><tt>one_class</tt> : int</dt>
<dd>bool whether the regression is a one class svm or not, defaults to false</dd>
<dt><tt>post_transform</tt> : string</dt>
<dd>post eval transform for score, enum NONE, SOFTMAX, LOGISTIC, SOFTMAX_ZERO, PROBIT</dd>
<dt><tt>rho</tt> : list of floats</dt>
<dd></dd>
<dt><tt>support_vectors</tt> : list of floats</dt>
<dd>chosen support vectors</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Data to be regressed</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : tensor(float)</dt>
<dd>Regression outputs (one score per target per example)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(double), tensor(int64), tensor(int32)</dt>
<dd> allowed types.</dd>
</dl>


### <a name="ai.onnx.ml.Scaler"></a><a name="ai.onnx.ml.scaler">**ai.onnx.ml.Scaler**</a>

  Rescale input data, for example to standardize features by removing the mean and scaling to unit variance.

#### Version

This version of the operator has been available since version 1 of the 'ai.onnx.ml' operator set.

#### Attributes

<dl>
<dt><tt>offset</tt> : list of floats</dt>
<dd>first, offset by this, must be same length as scale</dd>
<dt><tt>scale</tt> : list of floats</dt>
<dd>second, multiply by this, can be length of features or length 1</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Data to be scaled</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : tensor(float)</dt>
<dd>Scaled output data</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(double), tensor(int64), tensor(int32)</dt>
<dd> allowed types.</dd>
</dl>


### <a name="ai.onnx.ml.TreeEnsembleClassifier"></a><a name="ai.onnx.ml.treeensembleclassifier">**ai.onnx.ml.TreeEnsembleClassifier**</a>

  Tree Ensemble classifier.  Returns the top class for each input in N.
      All args with nodes_ are fields of a tuple of tree nodes, and
      it is assumed they are the same length, and an index i will decode the
      tuple across these inputs.  Each node id can appear only once
      for each tree id.
      All fields prefixed with class_ are tuples of votes at the leaves.
      A leaf may have multiple votes, where each vote is weighted by
      the associated class_weights index.
      It is expected that either classlabels_strings or classlabels_int64s
      will be passed and the class_ids are an index into this list.
      Mode enum is BRANCH_LEQ, BRANCH_LT, BRANCH_GTE, BRANCH_GT, BRANCH_EQ, BRANCH_NEQ, LEAF

#### Version

This version of the operator has been available since version 1 of the 'ai.onnx.ml' operator set.

#### Attributes

<dl>
<dt><tt>base_values</tt> : list of floats</dt>
<dd>base values for classification, added to final class score, size must be the same as classes or can be left unassigned (assumed 0)</dd>
<dt><tt>class_ids</tt> : list of ints</dt>
<dd>index of the class list that this weight is for</dd>
<dt><tt>class_nodeids</tt> : list of ints</dt>
<dd>node id that this weight is for</dd>
<dt><tt>class_treeids</tt> : list of ints</dt>
<dd>tree that this node is in</dd>
<dt><tt>class_weights</tt> : list of floats</dt>
<dd>the weight for the class in class_id</dd>
<dt><tt>classlabels_int64s</tt> : list of ints</dt>
<dd>class labels if using int labels</dd>
<dt><tt>classlabels_strings</tt> : list of strings</dt>
<dd>class labels if using string labels</dd>
<dt><tt>nodes_falsenodeids</tt> : list of ints</dt>
<dd>child node if expression is false</dd>
<dt><tt>nodes_featureids</tt> : list of ints</dt>
<dd>feature id for this node</dd>
<dt><tt>nodes_hitrates</tt> : list of floats</dt>
<dd></dd>
<dt><tt>nodes_missing_value_tracks_true</tt> : list of ints</dt>
<dd>for each node, decide if the value is missing (nan) then use true branch, this field can be left unset and will assume false for all nodes</dd>
<dt><tt>nodes_modes</tt> : list of strings</dt>
<dd>enum of behavior for this node 'BRANCH_LEQ', 'BRANCH_LT', 'BRANCH_GTE', 'BRANCH_GT', 'BRANCH_EQ', 'BRANCH_NEQ', 'LEAF'</dd>
<dt><tt>nodes_nodeids</tt> : list of ints</dt>
<dd>node id for this node, node ids may restart at zero for each tree (but not required).</dd>
<dt><tt>nodes_treeids</tt> : list of ints</dt>
<dd>tree id for this node</dd>
<dt><tt>nodes_truenodeids</tt> : list of ints</dt>
<dd>child node if expression is true</dd>
<dt><tt>nodes_values</tt> : list of floats</dt>
<dd>thresholds to do the splitting on for this node.</dd>
<dt><tt>post_transform</tt> : string</dt>
<dd>post eval transform for score, enum NONE, SOFTMAX, LOGISTIC, SOFTMAX_ZERO, PROBIT</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T1</dt>
<dd>Input N,F</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T2</dt>
<dd>N, Top class for each point</dd>
<dt><tt>Z</tt> : tensor(float)</dt>
<dd>N,E the class score for each class, for each point</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float), tensor(double), tensor(int64), tensor(int32)</dt>
<dd> allowed types.</dd>
<dt><tt>T2</tt> : tensor(string), tensor(int64)</dt>
<dd> allowed types.</dd>
</dl>


### <a name="ai.onnx.ml.TreeEnsembleRegressor"></a><a name="ai.onnx.ml.treeensembleregressor">**ai.onnx.ml.TreeEnsembleRegressor**</a>

  Tree Ensemble regressor.  Returns the regressed values for each input in N.
      All args with nodes_ are fields of a tuple of tree nodes, and
      it is assumed they are the same length, and an index i will decode the
      tuple across these inputs.  Each node id can appear only once
      for each tree id.
      All fields prefixed with target_ are tuples of votes at the leaves.
      A leaf may have multiple votes, where each vote is weighted by
      the associated target_weights index.
      All trees must have their node ids start at 0 and increment by 1.
      Mode enum is BRANCH_LEQ, BRANCH_LT, BRANCH_GTE, BRANCH_GT, BRANCH_EQ, BRANCH_NEQ, LEAF

#### Version

This version of the operator has been available since version 1 of the 'ai.onnx.ml' operator set.

#### Attributes

<dl>
<dt><tt>aggregate_function</tt> : string</dt>
<dd> enum, how to aggregate leaf values within a target, AVERAGE,SUM,MIN,MAX</dd>
<dt><tt>base_values</tt> : list of floats</dt>
<dd>base values for regression, added to final score, size must be the same as n_outputs or can be left unassigned (assumed 0)</dd>
<dt><tt>n_targets</tt> : int</dt>
<dd>total number of targets</dd>
<dt><tt>nodes_falsenodeids</tt> : list of ints</dt>
<dd>child node if expression is false</dd>
<dt><tt>nodes_featureids</tt> : list of ints</dt>
<dd>feature id for this node</dd>
<dt><tt>nodes_hitrates</tt> : list of floats</dt>
<dd>popularity of the node, used for performance and may be omitted</dd>
<dt><tt>nodes_missing_value_tracks_true</tt> : list of ints</dt>
<dd>for each node, decide if the value is missing (nan) then use true branch, this field can be left unset and will assume false for all nodes</dd>
<dt><tt>nodes_modes</tt> : list of strings</dt>
<dd>enum of behavior for this node as enum of BRANCH_LEQ, BRANCH_LT, BRANCH_GTE, BRANCH_GT, BRANCH_EQ, BRANCH_NEQ, LEAF</dd>
<dt><tt>nodes_nodeids</tt> : list of ints</dt>
<dd>node id for this node, node ids must restart at zero for each tree and increase sequentially.</dd>
<dt><tt>nodes_treeids</tt> : list of ints</dt>
<dd>tree id for this node</dd>
<dt><tt>nodes_truenodeids</tt> : list of ints</dt>
<dd>child node if expression is true</dd>
<dt><tt>nodes_values</tt> : list of floats</dt>
<dd>thresholds to do the splitting on for this node.</dd>
<dt><tt>post_transform</tt> : string</dt>
<dd>post eval transform for score, enum NONE, SOFTMAX, LOGISTIC, SOFTMAX_ZERO, PROBIT</dd>
<dt><tt>target_ids</tt> : list of ints</dt>
<dd>index of the class list that this weight is for</dd>
<dt><tt>target_nodeids</tt> : list of ints</dt>
<dd>node id that this weight is for</dd>
<dt><tt>target_treeids</tt> : list of ints</dt>
<dd>tree that this node is in</dd>
<dt><tt>target_weights</tt> : list of floats</dt>
<dd>the weight for the class in target_id</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input N,F</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : tensor(float)</dt>
<dd>N classes</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(double), tensor(int64), tensor(int32)</dt>
<dd> allowed types.</dd>
</dl>


### <a name="ai.onnx.ml.ZipMap"></a><a name="ai.onnx.ml.zipmap">**ai.onnx.ml.ZipMap**</a>

  Makes a map from the input and the attributes.
      Assumes input 0 are the values, and the keys are specified by the attributes.
      Must provide keys in either classlabels_strings or classlabels_int64s (but not both).
      Input 0 may have a batch size larger than 1,
      but each input in the batch must be the size of the keys specified by the attributes.
      The order of the input and attributes determines the key-value mapping.

#### Version

This version of the operator has been available since version 1 of the 'ai.onnx.ml' operator set.

#### Attributes

<dl>
<dt><tt>classlabels_int64s</tt> : list of ints</dt>
<dd>keys if using int keys</dd>
<dt><tt>classlabels_strings</tt> : list of strings</dt>
<dd>keys if using string keys</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : tensor(float)</dt>
<dd>The input values</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Z</tt> : T</dt>
<dd>The output map</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : seq(map(string, float)), seq(map(int64, float))</dt>
<dd> allowed types.</dd>
</dl>


