"""
Expes on semi-real data.
The aim is to plot ROC curves.
The aim is to study the influence of the amplitude, and of the number of epoch
on the signal.
"""

import numpy as np
from sklearn.utils import check_random_state

##########################################################################
# name of the expe
name_expe = "expe4"
rng = check_random_state(42)
n_repet_roc_curves = 1

name_dir_raw_res = "raw_results"
# list_amplitudes = "raw_results"
list_amplitudes = np.arange(1, 11)

resolution = 6
eeg = False
meg = "grad"
list_n_dipoles = [2]
n_times = 100
list_n_epochs = [10, 20, 30, 40, 50]
n_iter = 10 ** 4
active_set_freq = 15
S_freq = 10
tol = 10 ** -3

list_whiten = [False]
n_points_roc_auc = 40

list_pb_name = ["CLaR", "SGCL", "MLER", "MLE", "MRCER", "MRCE", "MTL"]

dict_list_p_alpha = {}
dict_list_p_alpha["CLaR"] = np.geomspace(1, 0.1, n_points_roc_auc)
dict_list_p_alpha["SGCL"] = np.geomspace(1, 0.7, n_points_roc_auc)
dict_list_p_alpha["MTLME"] = np.geomspace(1, 0.5, n_points_roc_auc)
dict_list_p_alpha["MTL"] = np.geomspace(1, 0.01, n_points_roc_auc)
dict_list_p_alpha["MLE"] = np.geomspace(1, 0.7, n_points_roc_auc)
dict_list_p_alpha["MLER"] = np.geomspace(1, 0.1, n_points_roc_auc)
dict_list_p_alpha["MRCE"] = np.geomspace(1, 0.7, n_points_roc_auc)
dict_list_p_alpha["MRCER"] = np.geomspace(1, 0.1, n_points_roc_auc)

dict_tol = {}
dict_tol["CLaR"] = 10 ** -3
dict_tol["SGCL"] = 10 ** -3
dict_tol["MLER"] = 10 ** -3
dict_tol["MLE"] = 10 ** -3
dict_tol["MRCE"] = 10 ** -3
dict_tol["MRCER"] = 10 ** -3
dict_tol["MTLME"] = 10 ** -3
dict_tol["MTL"] = 10 ** -3

dict_gap_freq = {}
dict_gap_freq["CLaR"] = 30
dict_gap_freq["SGCL"] = 30
dict_gap_freq["MLER"] = 30
dict_gap_freq["MLE"] = 30
dict_gap_freq["MRCE"] = 30
dict_gap_freq["MRCER"] = 30
dict_gap_freq["MTLME"] = 30
dict_gap_freq["MTL"] = 30

n_jobs = len(list_pb_name) * len(list_n_dipoles) * len(list_n_epochs) * \
         len(list_amplitudes)
print("njobs = ", n_jobs)

list_seed = [0]
