import tensorflow.keras.backend as K

from .OneHotModel import OneHotModel


class OneHotEvolutionaryModel(OneHotModel):

    def call(self, inputs):
        encoder_output = K.one_hot(inputs['sequence'], self._n_symbols)
        encoder_output = K.concatenate((encoder_output, inputs['hmm_profile']))
        inputs['encoder_output'] = encoder_output
        return inputs
