#include "double_matrix.h"

/* Standard allocation function, with initialization of the elements. */
double_matrix_t* double_matrix_alloc(size_t nbrows, size_t nbcols)
{
  size_t i;

  double_matrix_t* mat = (double_matrix_t*)malloc(sizeof(double_matrix_t));
  mat->nbrows = mat->_maxrows = nbrows;
  mat->nbcolumns = nbcols;
  mat->p = (double**)malloc(nbrows * sizeof(double*));
  mat->nbeq = 0;
  for (i=0;i<nbrows;i++){
    mat->p[i] = (double*)calloc(nbcols,sizeof(double));
  }
  return mat;
}


/* Reallocation function, to scale up or to downsize a matrix */
void matrix_resize_rows(double_matrix_t* mat, size_t nbrows)
{
  size_t i;

  if (nbrows > mat->_maxrows){
    mat->p = (double**)realloc(mat->p, nbrows * sizeof(double*));
    for (i=mat->_maxrows; i<nbrows; i++){
      mat->p[i] = (double*)calloc(mat->nbcolumns,sizeof(double));
    }
  }
  else if (nbrows < mat->_maxrows){
    for (i=nbrows; i<mat->_maxrows; i++){
       free(mat->p[i]);
    }
    mat->p = (double**)realloc(mat->p,nbrows * sizeof(double*));
  }
  mat->_maxrows = nbrows;
  mat->nbrows = nbrows;
}


/* Deallocation function. */
void double_matrix_free(double_matrix_t* omat)
{
  size_t i;
  for (i=0;i<omat->_maxrows;i++){
    free(omat->p[i]);
    omat->p[i] = NULL;
  }
  if(omat->p){
  	free(omat->p);
	omat->p = NULL;
  }
  free(omat);
  omat = NULL;
}


/*********************************************************
	Rearranges the matrix so all the equalities are at the start
**********************************************************/

void double_matrix_exch_rows(double_matrix_t* om, size_t l1, size_t l2)
{
  double* tmp =om->p[l1];
  om->p[l1]=om->p[l2];
  om->p[l2]=tmp;
}


void double_matrix_rearrange(double_matrix_t *oc){
	size_t nbeq = oc->nbeq;
	size_t i=0,k=0;
	size_t nbcons = oc->nbrows;
 	size_t nbcolumns = oc->nbcolumns;
	double **p = oc->p;
	while((i<nbcons) && (k < nbeq)){
		while((i < nbcons) && p[i][0]){
			i++;
		}
		if(i< nbcons){
			if(i!=k){
				double_matrix_exch_rows(oc,i,k);
			}
			i++;
			k++;
		}
	}
}


/* Raw printing function. */
void double_matrix_print(double_matrix_t* mat)
{
  size_t i,j;
  printf("%lu %lu\n", 
	  (unsigned long)mat->nbrows, (unsigned long)mat->nbcolumns);
  for (i=0;i<mat->nbrows;i++) {
    for (j=0;j<mat->nbcolumns;j++){
	//if((j>2) && (mat->p[i][j] !=0))
		//fprintf(stdout,"%d ",j-3);
      //numint_fprint(stream,mat->p[i][j]);
      printf("%g ",mat->p[i][j]);
    }
    printf("\n");
  }
}


size_t get_num_rows(double_matrix_t *mat){
	return mat->nbrows;
}


double get_matrix_element(double_matrix_t *mat, size_t i, size_t j){
	return mat->p[i][j];
}
