import calc_frechet
import numpy as np
import pandas as pd
import sys
import os
import json

def import_from_txt(path):
    data = pd.read_csv(path, sep=" ", header=None)
    return data

#Import the data

files = os.listdir("../data/ghg_data")

T = calc_frechet.Curves()

for f in files:
	data = import_from_txt("../data/ghg_data/{}".format(f))
	data_np = np.array(data.values, dtype="d")
	t = calc_frechet.Curve(data_np)
	T.add(t)
	
result = calc_frechet.onemedian_exhaustive(T)

dump = {
	'method': 'exact_worp',
	'data': {
		'name': "ghg_data",
		'lengths': T[0].points,
		'dimension': T[0].dimensions,
		'epsilon1': 0,
		'epsilon2': 0,
	},
	'without_rp': { 
		'value': result.value,
		'centers': result[0],
		'running-time': result.running_time,
	},
	'with_rp': { 
		'value': result.value,
		'centers': result[0],
		'running-time': result.running_time,
	},
}

print(json.dumps(dump))
