library("rjson")
library("rstudioapi")
library("ggpubr")
library("tidyverse")

current_path = rstudioapi::getActiveDocumentContext()$path 
setwd(dirname(current_path))
files <- list.files("./onemed_delta")

frame <- data.frame(epsilon1=c(), epsilon2=c(), value=c(), method=c(), time=c(), algorithm=c(),
                    dimensions=c(), points=c(), centers=c(), assignment=c())

c <- 0
acc <- 0

for (file in files) {
  json_data <- fromJSON(file=paste(getwd(), "/onemed_delta/", file, sep=""))
  
  method <- json_data$method
  epsilon1 <- json_data$data$epsilon1
  epsilon2 <- json_data$data$epsilon2
  number_points <- json_data$data$lengths
  number_dimensions <- json_data$data$dimension
  values <- list(json_data$without_rp$value, 
                 json_data$with_rp$value)
  times <- list(json_data$without_rp$`running-time`, json_data$with_rp$`running-time`)
  centers <- list(json_data$without_rp$centers, json_data$with_rp$centers)
  c <- c + 1
  # if (k == 5) {
  #   print(assignments[[1]])
  # }
  # data <- list(datanames, values, times_searches, number_searches, times_bounds, epsilon)
  # key <- paste(datanames, epsilon)
  # print(paste("found data:", key))
  frame <- rbind(frame, data.frame(epsilon1=epsilon1, epsilon2=epsilon2, value=values[[1]],
                                   time=times[[1]]/60,
                                   algorithm="parallel",
                                   dimensions=number_dimensions,
                                   points=number_points,
                                   method=method))
  frame <- rbind(frame, data.frame(epsilon1=epsilon1, epsilon2=epsilon2, value=values[[2]],
                                   time=times[[2]]/60,
                                   algorithm="parallel_rp",
                                   dimensions=number_dimensions,
                                   points=number_points,
                                   method=method))
}

data <- frame %>%
  group_by_at(vars(method, epsilon1, epsilon2, algorithm)) %>%
  mutate(parameters = paste(epsilon1, epsilon2, sep=", "))

data_worp <- data %>%
  filter(algorithm=="parallel")

data_wrp <- data %>%
  filter(algorithm=="parallel_rp")


p1 <- ggplot(data, aes(factor(parameters), time)) +  
  #ggtitle("DELTA Clustering Running-Time") +
  #theme(legend.position="none") +
  scale_x_discrete(name = "epsilon") +
  scale_y_log10(name = "running-time [min]") +
  #scale_fill_brewer(palette = "Set1") +
  geom_boxplot(aes(fill = algorithm), coef = 0, outlier.alpha = 0) +
  geom_boxplot(aes(color = algorithm),
               fatten = NULL, fill = NA, coef = 0, outlier.alpha = 0,
               show.legend = F)

p2 <- ggplot(data_wrp, aes(fill=algorithm)) +
  #ggtitle("DELTA Clustering Objective") +
  scale_x_discrete(name = "k") +
  scale_y_continuous(name = "objective value") +
  geom_boxplot(aes(factor(k), value), coef=0, outlier.alpha = 0.1) +
  geom_point(data=data_worp, aes(factor(k), value, color=algorithm), size=2) +
  theme(legend.position="none")

#ggarrange(p1, p2, ncol=2, nrow=1, common.legend = TRUE)
ggarrange(p2, ncol=1, nrow=1, common.legend = TRUE)