import calc_frechet
import numpy as np
import pandas as pd
import sys
import os
import json

if len(sys.argv) < 3:
	epsilon = 0.75
	k = 2
else:
	k = int(sys.argv[2])
	epsilon = float(sys.argv[1])

def import_from_txt(path):
    data = pd.read_csv(path, sep=",")
    return data

#Import the data

files = os.listdir("../data/DELTA")

T = calc_frechet.Curves()

for f in files:
	data = import_from_txt("../data/DELTA/{}".format(f))
	data_np = np.array(data.values[:,2:], dtype="d")
	t = calc_frechet.Curve(data_np)
	T.add(t)
	
T_rp = calc_frechet.jl_transform(T, epsilon)

result = calc_frechet.kcenter_with_assignment(k, T)
result_rp = calc_frechet.kcenter_with_assignment(k, T_rp)

dump = {
	'data': {
		'name': "DELTA",
		'lengths': [T[0].points, T[1].points],
		'dimension': [T[0].dimensions, T[1].dimensions],
		'epsilon': epsilon,
		'k': k,
	},
	'without_rp': { 
		'value': result.value,
		'centers': [result[i] for i in range(0, k)],
		'running-time': result.running_time,
		'assignment': [[result.assignment.get(i,j) for j in range(0, result.assignment.count(i))] for i in range(0, k)],
		},
	'with_rp': { 
		'value': result_rp.value,
		'centers': [result_rp[i] for i in range(0, k)],
		'running-time': result_rp.running_time,
		'assignment': [[result.assignment.get(i,j) for j in range(0, result.assignment.count(i))] for i in range(0, k)],
		},
}

print(json.dumps(dump))
