function [C, leftClusters] = proj_wrapper(inputFile,ks,setting,taus,gammas,thresholds,minClusterSize,varargin)

%		All variables are as in the paper except:
%		- minClusterSize is L in the paper
%		- threshold is theta in the paper
%		- k is the value for k given to the SVD
%		- tau is the value for k given to k-means
%		- gamma and setting can be ignored
%		You can pass vectors for the parameters and the algorithm will iterate
%		over all of them.

% order of the variable arguments:
% 	- clustering --- must be 'kmeans'
	numvarargs = length(varargin);

	optargs = {'kmeans'}; % set default optional arguments
	if numvarargs > 0
		opargs(1:numvarargs) = varargin{:}; % get input from variable arguments list
	end
	[clustering] = optargs{:}; % put arguments into proper variable names

	pythonPath = SETUP_matlab('SETUP_PYTHON_PATH');
	pythonFile = SETUP_matlab('SETUP_PCV_PATH');
	outFile = tempname();
	clusterOutputFile = tempname();

	ksString = createParamString('-k',ks,'int');
	tausString = createParamString('--tau',taus,'float');
	gammasString = createParamString('--gamma',gammas,'float');
	thresholdsString = createParamString('--threshold', thresholds,'float');

	call = [pythonPath ' ' pythonFile];
   	call = [call ' -i ' inputFile];
	call = [call ' -o ' outFile];
   	call = [call ' --clusterOutputFile ' clusterOutputFile ];
	call = [call ksString];
	call = [call '--setting ' setting];
	call = [call tausString gammasString thresholdsString];
	call = [call ' --minClusterSize ' int2str(minClusterSize)];
   	call = [call ' --verbose 0' ];

	[status result] = unix(call);

	if status ~= 0
		error(['proj returned an error code ' int2str(status) ' with text ' result]);
	end

	C = readFileIfExists(outFile);
	leftClusters = readFileIfExists(clusterOutputFile);

	delete(outFile)
	delete(clusterOutputFile)
end

function [ C ] = readFileIfExists(outFile)
	nonemptyOutfile = 0;
	if exist(outFile, 'file')
		fid = fopen(outFile);    
		line_ = fgets(fid);    
		if ~(isequal(line_, -1)) 
			nonemptyOutfile = 1;
		end
	end

	if nonemptyOutfile == 1
		C = csvread(outFile);
	else
		C = [];
	end
	
end

function [paramString] = createParamString(parameter, parameterValues, conversionType)
	paramString = '';

	for i = 1:length(parameterValues)
		parameterValue = parameterValues(i);
		parameterValueString = '';
		if strcmp(conversionType, 'int')
			parameterValueString = int2str(parameterValue);
		elseif strcmp(conversionType, 'float')
			parameterValueString = num2str(parameterValue);
		end

		paramString = [paramString ' ' parameter ' ' parameterValueString ' '];
	end
end

