% prior_sample_affine_model:

function [a, b, f_obs, theta] = prior_sample_affine_model(X_space, do_params_X_space, hyper_a, M)

%% Preliminaries

num_X_space = length(X_space);

%% Prepare prior information

mu_f = do_params_X_space.mu_do;
K_f_chol  = chol(do_params_X_space.K)';

%% Main sampling

a = ones(num_X_space, M); 
b = ones(num_X_space, M); 
f_obs = zeros(num_X_space, M); 

a_sf2 = exp(randn(M, 1) * sqrt(hyper_a.sf2.var) + hyper_a.sf2.mu);
a_ell = exp(randn(M, 1) * sqrt(hyper_a.ell.var) + hyper_a.ell.mu);
b_sf2 = exp(randn(M, 1) * sqrt(hyper_a.sf2.var) + hyper_a.sf2.mu);
b_ell = exp(randn(M, 1) * sqrt(hyper_a.ell.var) + hyper_a.ell.mu);

sd = sqrt(diag(do_params_X_space.K)); sd = sd / max(sd);
SD2 = sd * sd';
X1 = X_space - min(X_space); X1 = X1 / max(X1);
Y1 = do_params_X_space.mu_do - min(do_params_X_space.mu_do); Y1 = Y1 / max(Y1);
core = (X1(:, ones(num_X_space, 1)) - X1(:, ones(num_X_space, 1))').^2 + ...
       (Y1(:, ones(num_X_space, 1)) - Y1(:, ones(num_X_space, 1))').^2 ;
noise_matrix = get_noise_matrix(num_X_space);

for m = 1:M    
    
   core_h = exp(-0.5 * core / a_ell(m));
   K_h = a_sf2(m) * SD2 .* core_h + noise_matrix;
   a(:, m) = 1 + chol(K_h)' * randn(num_X_space, 1);   
   
   core_b = exp(-0.5 * core / b_ell(m));
   K_b = b_sf2(m) * SD2 .* core_b + noise_matrix;
   b(:, m) = chol(K_b)' * randn(num_X_space, 1);   
   
   f_obs(:, m) = mu_f + K_f_chol * randn(num_X_space, 1);
   
end

theta.a_sf2 = a_sf2;
theta.a_ell = a_ell;

theta.b_sf2 = b_sf2;
theta.b_ell = b_ell;
