% Loads results from one trial of the real-valued experiment
function [ cost, F, G ] = load_real(H, NC, SC, Spec, TI, epsilon, N, Seed)

  filename = ['~/output_real/' int2str(H) '_' int2str(NC) '_' int2str(SC) '_' int2str(Spec) '_' int2str(TI) '_' num2str(epsilon, '%.1f') '_' int2str(N) '_' int2str(Seed) '.txt'];
  fid = fopen(filename);

  cost = fscanf(fid, '%d', [1, 1]);
  A = fscanf(fid, '%f', [2, inf]);
  F = A(1, :);
  G = A(2, :);

  fclose(fid);
end

