function msbm_gui_chain(hObject, handles)
        
    theta       = handles.active_theta;
    mask        = handles.mask;
    sv_clamp    = reshape(handles.ground', [1 handles.settings.H*handles.settings.W handles.dataset.L]);
    
    sv          = sv_clamp;
    sh2         = rand(1, theta.num_hidden2) > 0.5;
    
    count       = handles.settings.gibbs_skip;

    while equals(get(handles.pushbutton1, 'Enable'), 'off')
               
        % sample
        sh1 = msbm_sample_h1(theta, sv, sh2);
        sh2 = msbm_sample_h2(theta, sh1);
        sh1 = msbm_sample_h1(theta, sv, sh2);
        [sv, pv] = msbm_sample_v(theta, sh1);
        
        % store
        handles.pv = reshape(pv, [handles.settings.H*handles.settings.W handles.dataset.L])';
                
        % clamp
        sv(1, ~mask, :) = sv_clamp(1, ~mask, :);
        
        % skip iterations
        if count > handles.settings.gibbs_skip
            msbm_gui_draw(handles);
            count = 1;
        else
            count = count + 1;
        end
        
        guidata(hObject, handles);
        
    end

end