% Figures show the histograms of:
% 
%   1: Hamming distances between all pairs of codewords in the codebook.
%   2: Weight (i.e. the number of targets per codeword)
%   3: #TTI=1, the number of occasions per codeword where targets occur on
%      consecutive epochs
%   4: E(TTI),  the mean TTI per codeword
% 
% The bottom panel shows the code itself (black=stimulus event, white=no
% stimulus event).
% 
% 
% RC codes are shown in their 24-bit versions (i.e. two full cycles through the
% rows and columns).
% 
% Since the order of row and column flashes is randomized per cycle letter in
% RC_sep and RC_mix, and since the assignment of codewords to letters is
% randomized in the other codebooks, the codebooks given here are only examples
% of their class.
code(1).description = 'RC_{mix}';
code(1).example = [
1  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  1  0  0  0
1  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  1  0  0
1  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0
1  0  0  1  0  0  0  0  0  0  0  0  1  0  0  0  0  1  0  0  0  0  0  0
1  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0
1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  1  0
0  0  0  0  1  0  0  0  0  0  1  0  0  0  0  0  0  0  0  1  1  0  0  0
0  0  1  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  1  0  1  0  0
0  0  0  0  0  0  0  1  0  0  1  0  0  0  0  0  0  0  1  1  0  0  0  0
0  0  0  1  0  0  0  0  0  0  1  0  1  0  0  0  0  0  0  1  0  0  0  0
0  0  0  0  0  0  0  0  1  0  1  0  0  0  0  0  1  0  0  1  0  0  0  0
0  1  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  1  0  0  1  0
0  0  0  0  1  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  0  1
0  0  1  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  1
0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  1
0  0  0  1  0  0  1  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  1
0  0  0  0  0  0  1  0  1  0  0  0  0  0  0  0  1  0  0  0  0  0  0  1
0  1  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  1
0  0  0  0  1  1  0  0  0  0  0  0  0  0  0  1  0  0  0  0  1  0  0  0
0  0  1  0  0  1  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  1  0  0
0  0  0  0  0  1  0  1  0  0  0  0  0  0  0  1  0  0  1  0  0  0  0  0
0  0  0  1  0  1  0  0  0  0  0  0  1  0  0  1  0  0  0  0  0  0  0  0
0  0  0  0  0  1  0  0  1  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0
0  1  0  0  0  1  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  1  0
0  0  0  0  1  0  0  0  0  0  0  1  0  1  0  0  0  0  0  0  1  0  0  0
0  0  1  0  0  0  0  0  0  0  0  1  0  1  0  0  0  0  0  0  0  1  0  0
0  0  0  0  0  0  0  1  0  0  0  1  0  1  0  0  0  0  1  0  0  0  0  0
0  0  0  1  0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0  0  0  0
0  0  0  0  0  0  0  0  1  0  0  1  0  1  0  0  1  0  0  0  0  0  0  0
0  1  0  0  0  0  0  0  0  0  0  1  0  1  0  0  0  0  0  0  0  0  1  0
0  0  0  0  1  0  0  0  0  1  0  0  0  0  1  0  0  0  0  0  1  0  0  0
0  0  1  0  0  0  0  0  0  1  0  0  0  0  1  0  0  0  0  0  0  1  0  0
0  0  0  0  0  0  0  1  0  1  0  0  0  0  1  0  0  0  1  0  0  0  0  0
0  0  0  1  0  0  0  0  0  1  0  0  1  0  1  0  0  0  0  0  0  0  0  0
0  0  0  0  0  0  0  0  1  1  0  0  0  0  1  0  1  0  0  0  0  0  0  0
0  1  0  0  0  0  0  0  0  1  0  0  0  0  1  0  0  0  0  0  0  0  1  0
];

code(2).description = 'RC_{sep}';
code(2).example = [
0  0  0  0  0  1  0  1  0  0  0  0  0  0  1  0  0  0  0  0  0  1  0  0
0  0  0  0  0  1  1  0  0  0  0  0  0  0  1  0  0  0  0  1  0  0  0  0
0  0  0  0  0  1  0  0  0  1  0  0  0  0  1  0  0  0  0  0  0  0  1  0
0  0  0  0  0  1  0  0  0  0  1  0  0  0  1  0  0  0  1  0  0  0  0  0
0  0  0  0  0  1  0  0  1  0  0  0  0  0  1  0  0  0  0  0  1  0  0  0
0  0  0  0  0  1  0  0  0  0  0  1  0  0  1  0  0  0  0  0  0  0  0  1
0  1  0  0  0  0  0  1  0  0  0  0  0  1  0  0  0  0  0  0  0  1  0  0
0  1  0  0  0  0  1  0  0  0  0  0  0  1  0  0  0  0  0  1  0  0  0  0
0  1  0  0  0  0  0  0  0  1  0  0  0  1  0  0  0  0  0  0  0  0  1  0
0  1  0  0  0  0  0  0  0  0  1  0  0  1  0  0  0  0  1  0  0  0  0  0
0  1  0  0  0  0  0  0  1  0  0  0  0  1  0  0  0  0  0  0  1  0  0  0
0  1  0  0  0  0  0  0  0  0  0  1  0  1  0  0  0  0  0  0  0  0  0  1
0  0  0  1  0  0  0  1  0  0  0  0  0  0  0  1  0  0  0  0  0  1  0  0
0  0  0  1  0  0  1  0  0  0  0  0  0  0  0  1  0  0  0  1  0  0  0  0
0  0  0  1  0  0  0  0  0  1  0  0  0  0  0  1  0  0  0  0  0  0  1  0
0  0  0  1  0  0  0  0  0  0  1  0  0  0  0  1  0  0  1  0  0  0  0  0
0  0  0  1  0  0  0  0  1  0  0  0  0  0  0  1  0  0  0  0  1  0  0  0
0  0  0  1  0  0  0  0  0  0  0  1  0  0  0  1  0  0  0  0  0  0  0  1
0  0  0  0  1  0  0  1  0  0  0  0  0  0  0  0  0  1  0  0  0  1  0  0
0  0  0  0  1  0  1  0  0  0  0  0  0  0  0  0  0  1  0  1  0  0  0  0
0  0  0  0  1  0  0  0  0  1  0  0  0  0  0  0  0  1  0  0  0  0  1  0
0  0  0  0  1  0  0  0  0  0  1  0  0  0  0  0  0  1  1  0  0  0  0  0
0  0  0  0  1  0  0  0  1  0  0  0  0  0  0  0  0  1  0  0  1  0  0  0
0  0  0  0  1  0  0  0  0  0  0  1  0  0  0  0  0  1  0  0  0  0  0  1
1  0  0  0  0  0  0  1  0  0  0  0  1  0  0  0  0  0  0  0  0  1  0  0
1  0  0  0  0  0  1  0  0  0  0  0  1  0  0  0  0  0  0  1  0  0  0  0
1  0  0  0  0  0  0  0  0  1  0  0  1  0  0  0  0  0  0  0  0  0  1  0
1  0  0  0  0  0  0  0  0  0  1  0  1  0  0  0  0  0  1  0  0  0  0  0
1  0  0  0  0  0  0  0  1  0  0  0  1  0  0  0  0  0  0  0  1  0  0  0
1  0  0  0  0  0  0  0  0  0  0  1  1  0  0  0  0  0  0  0  0  0  0  1
0  0  1  0  0  0  0  1  0  0  0  0  0  0  0  0  1  0  0  0  0  1  0  0
0  0  1  0  0  0  1  0  0  0  0  0  0  0  0  0  1  0  0  1  0  0  0  0
0  0  1  0  0  0  0  0  0  1  0  0  0  0  0  0  1  0  0  0  0  0  1  0
0  0  1  0  0  0  0  0  0  0  1  0  0  0  0  0  1  0  1  0  0  0  0  0
0  0  1  0  0  0  0  0  1  0  0  0  0  0  0  0  1  0  0  0  1  0  0  0
0  0  1  0  0  0  0  0  0  0  0  1  0  0  0  0  1  0  0  0  0  0  0  1
];

code(3).description = 'RC_{sep} scrambled';
code(3).example = [
0  0  0  1  0  0  0  0  0  0  0  1  0  1  0  0  0  0  1  0  0  0  0  0
0  0  0  0  0  1  0  0  1  0  0  0  1  0  0  0  0  0  0  0  0  0  1  0
1  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  1
0  0  0  1  0  0  0  0  0  1  0  0  0  1  0  0  0  0  0  1  0  0  0  0
0  1  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  1  0  0  1  0  0  0
1  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  1  0  0  0  0  0  1  0
1  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  1  0  0  0  1  0  0  0
0  0  1  0  0  0  0  0  0  1  0  0  0  0  1  0  0  0  0  1  0  0  0  0
0  0  0  1  0  0  0  0  1  0  0  0  0  1  0  0  0  0  0  0  0  0  1  0
0  0  1  0  0  0  0  0  1  0  0  0  0  0  1  0  0  0  0  0  0  0  1  0
0  0  0  0  1  0  0  0  0  0  0  1  0  0  0  1  0  0  1  0  0  0  0  0
0  0  0  0  1  0  1  0  0  0  0  0  0  0  0  1  0  0  0  0  1  0  0  0
0  1  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  1  0  0  0  0  1  0
0  0  0  0  0  1  0  0  0  0  0  1  1  0  0  0  0  0  1  0  0  0  0  0
0  0  0  0  1  0  0  0  0  0  1  0  0  0  0  1  0  0  0  0  0  1  0  0
0  0  0  0  0  1  0  1  0  0  0  0  1  0  0  0  0  0  0  0  0  0  0  1
0  0  1  0  0  0  1  0  0  0  0  0  0  0  1  0  0  0  0  0  1  0  0  0
0  0  0  0  0  1  0  0  0  1  0  0  1  0  0  0  0  0  0  1  0  0  0  0
0  1  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  1  1  0  0  0  0  0
0  0  0  0  0  1  0  0  0  0  1  0  1  0  0  0  0  0  0  0  0  1  0  0
0  0  1  0  0  0  0  1  0  0  0  0  0  0  1  0  0  0  0  0  0  0  0  1
1  0  0  0  0  0  0  0  0  0  0  1  0  0  0  0  1  0  1  0  0  0  0  0
0  0  0  0  1  0  0  1  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  1
0  0  0  0  1  0  0  0  0  1  0  0  0  0  0  1  0  0  0  1  0  0  0  0
0  0  1  0  0  0  0  0  0  0  0  1  0  0  1  0  0  0  1  0  0  0  0  0
0  1  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  1  0  0  0  1  0  0
0  0  0  0  1  0  0  0  1  0  0  0  0  0  0  1  0  0  0  0  0  0  1  0
0  0  0  0  0  1  1  0  0  0  0  0  1  0  0  0  0  0  0  0  1  0  0  0
0  1  0  0  0  0  0  0  0  1  0  0  0  0  0  0  0  1  0  1  0  0  0  0
0  1  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  1
0  0  1  0  0  0  0  0  0  0  1  0  0  0  1  0  0  0  0  0  0  1  0  0
0  0  0  1  0  0  0  1  0  0  0  0  0  1  0  0  0  0  0  0  0  0  0  1
1  0  0  0  0  0  0  0  0  1  0  0  0  0  0  0  1  0  0  1  0  0  0  0
1  0  0  0  0  0  0  0  0  0  1  0  0  0  0  0  1  0  0  0  0  1  0  0
0  0  0  1  0  0  0  0  0  0  1  0  0  1  0  0  0  0  0  0  0  1  0  0
0  0  0  1  0  0  1  0  0  0  0  0  0  1  0  0  0  0  0  0  1  0  0  0
];

code(4).description = 'D10';
code(4).example = [
0  0  1  1  1  1  0  0  1  0  1  0  0  0  0  0  0  0  0  0  0  1  1  1
0  1  0  0  0  0  1  1  0  0  0  1  1  1  1  1  1  0  0  0  0  0  0  0
1  0  1  0  0  1  0  0  0  1  0  0  0  0  0  0  0  1  1  1  1  0  1  0
1  0  0  1  1  0  0  0  1  0  1  1  1  0  0  1  1  0  0  0  0  0  0  0
0  0  0  0  0  0  1  1  0  1  0  0  0  1  1  0  0  0  1  1  0  1  0  1
0  1  1  0  0  1  0  0  1  0  1  1  0  0  0  1  0  1  0  0  1  0  0  0
0  0  0  1  1  0  0  1  0  1  0  0  1  0  1  0  1  0  0  0  0  1  1  0
1  1  0  0  0  1  1  0  0  0  1  0  0  1  0  0  0  0  1  0  1  0  0  1
0  0  1  0  1  0  0  1  1  0  0  0  0  0  0  1  1  1  0  1  0  0  1  0
1  1  0  1  0  0  0  0  0  1  0  1  1  0  0  0  0  0  1  0  0  1  0  1
0  0  0  0  1  1  1  0  0  0  0  0  0  1  1  1  0  1  0  1  1  0  0  0
0  1  1  0  0  0  0  1  0  1  1  1  0  0  0  0  1  0  0  0  0  0  1  1
1  0  0  1  0  1  0  0  1  0  0  0  1  1  1  0  0  1  0  0  0  1  0  0
0  0  0  0  1  0  1  1  0  0  1  1  0  0  0  0  0  0  1  1  1  0  1  0
1  1  1  0  0  0  0  0  1  1  0  0  0  1  0  1  1  0  0  0  0  1  0  0
0  0  0  1  1  1  1  1  0  0  0  0  1  0  0  0  0  1  1  0  0  0  0  1
1  1  0  0  0  0  0  0  0  0  1  0  0  0  1  1  0  0  0  1  1  1  1  0
0  0  0  1  0  1  1  0  1  1  0  1  0  1  0  0  1  0  0  0  0  0  0  1
0  0  1  0  0  0  0  1  0  0  0  0  1  0  1  1  0  1  1  0  1  1  0  0
1  1  0  1  1  1  0  0  0  0  0  1  0  1  0  0  0  0  0  1  0  0  1  0
0  0  0  0  0  0  1  1  1  1  1  0  1  0  0  0  1  1  0  0  1  0  0  0
1  0  1  0  1  0  0  0  0  0  0  1  0  0  1  1  0  0  1  0  0  0  1  1
0  1  0  1  0  1  0  0  0  1  1  0  0  0  0  0  1  1  0  1  0  1  0  0
0  0  1  0  0  0  1  0  1  0  0  0  1  1  0  1  0  0  0  0  1  0  1  1
1  1  0  0  1  0  0  1  0  1  1  0  0  0  1  0  0  1  1  0  0  0  0  0
0  0  1  1  0  0  0  0  0  0  0  1  1  1  0  0  1  0  0  1  1  1  0  0
1  1  0  0  0  1  0  1  1  0  0  0  1  0  0  1  0  0  1  0  0  0  1  0
0  0  0  0  1  0  0  0  0  0  1  1  0  1  1  0  1  1  0  0  0  1  0  1
0  1  0  1  0  0  1  0  1  1  0  0  0  0  0  1  0  0  1  1  1  0  0  0
1  0  1  0  0  1  0  1  0  0  1  1  1  0  1  0  0  0  0  1  0  0  0  0
0  1  0  0  1  0  1  0  0  1  0  0  0  0  0  1  0  1  0  0  0  1  1  1
0  0  0  1  0  0  0  0  1  0  1  0  0  1  1  0  1  0  1  1  0  0  1  0
1  0  1  0  1  0  1  1  0  0  0  0  0  0  0  0  1  0  0  0  1  1  0  1
0  0  0  0  0  1  0  0  0  1  1  1  1  1  0  1  0  0  0  0  0  1  1  0
0  1  0  0  1  0  0  0  1  0  0  0  1  0  1  0  1  0  0  1  1  0  0  1
1  0  0  1  0  0  0  1  0  0  1  0  0  1  0  1  0  1  0  0  0  0  1  1
];

code(5).description = 'D8_{opt}';
code(5).example = [
1  0  1  0  0  0  1  0  1  0  0  1  0  1  0  0  0  0  0  0  0  0  0  0
0  1  0  0  1  0  0  1  0  0  1  0  1  0  1  0  0  1  0  0  1  0  0  1
0  0  0  1  0  1  0  0  0  1  0  0  1  0  0  1  0  0  1  0  0  0  1  0
0  1  0  0  0  1  0  0  0  1  0  0  0  1  0  0  1  0  0  1  0  1  0  1
1  0  0  1  0  0  0  1  0  0  1  0  0  0  1  0  1  0  0  1  0  0  1  0
0  0  1  0  1  0  0  1  0  0  0  1  0  0  0  1  0  0  1  0  0  1  0  1
0  1  0  0  0  1  0  0  1  0  0  1  0  0  1  0  0  1  0  0  1  0  1  0
1  0  0  0  1  0  1  0  0  1  0  0  1  0  0  0  1  0  0  0  1  0  0  1
0  0  0  1  0  0  1  0  0  0  1  0  0  1  0  0  0  1  0  0  0  1  0  0
0  0  1  0  1  0  0  0  1  0  0  0  1  0  0  1  0  0  0  1  0  0  1  0
1  0  0  0  0  1  0  0  1  0  1  0  0  0  1  0  0  0  1  0  0  1  0  1
0  1  0  0  1  0  0  1  0  0  1  0  0  1  0  0  1  0  1  0  0  0  1  0
0  0  1  0  0  0  1  0  0  1  0  1  0  0  1  0  0  1  0  0  1  0  0  1
0  1  0  1  0  0  1  0  1  0  0  1  0  0  0  1  0  0  0  1  0  0  0  1
1  0  0  0  1  0  0  1  0  1  0  0  1  0  0  1  0  1  0  0  0  1  0  0
0  0  1  0  0  1  0  1  0  0  1  0  0  1  0  0  1  0  0  0  1  0  0  1
0  1  0  0  0  0  1  0  0  1  0  0  1  0  1  0  0  0  1  0  0  1  0  0
1  0  0  1  0  1  0  0  1  0  0  0  0  1  0  0  0  1  0  1  0  0  1  0
1  0  0  1  0  0  0  1  0  0  0  1  0  0  1  0  0  0  1  0  1  0  0  1
0  0  1  0  0  1  0  0  0  1  0  1  0  0  1  0  1  0  0  1  0  0  1  0
0  0  0  1  0  0  0  0  1  0  0  0  1  0  0  0  1  0  0  0  0  1  0  1
0  1  0  0  0  0  1  0  0  0  1  0  0  0  0  1  0  0  0  0  1  0  1  0
1  0  0  0  1  0  0  1  0  0  1  0  0  1  0  1  0  0  0  1  0  0  0  1
0  1  0  0  1  0  0  0  1  0  0  1  0  1  0  0  0  1  0  0  0  1  0  1
1  0  0  0  0  1  0  0  1  0  0  0  1  0  0  1  0  1  0  0  1  0  0  1
0  0  1  0  0  0  1  0  0  1  0  0  0  1  0  0  1  0  1  0  1  0  1  0
1  0  0  0  1  0  1  0  0  1  0  0  0  0  1  0  0  1  0  1  0  0  1  0
0  1  0  0  0  1  0  1  0  0  1  0  1  0  0  1  0  0  0  1  0  1  0  0
1  0  0  0  1  0  0  0  1  0  0  1  0  0  1  0  1  0  1  0  0  0  1  0
0  0  0  1  0  0  0  1  0  1  0  0  0  1  0  1  0  1  0  0  1  0  0  1
0  0  1  0  0  0  1  0  0  0  1  0  0  0  1  0  1  0  0  1  0  1  0  1
0  1  0  0  1  0  0  1  0  0  0  1  0  0  1  0  1  0  0  1  0  1  0  0
1  0  0  1  0  0  0  1  0  1  0  0  0  1  0  0  1  0  1  0  0  1  0  0
0  0  1  0  0  1  0  1  0  1  0  0  1  0  0  0  0  1  0  1  0  0  0  1
0  1  0  1  0  0  0  0  1  0  1  0  0  1  0  0  0  0  1  0  1  0  0  1
1  0  1  0  0  1  0  1  0  0  0  1  0  0  0  1  0  0  0  0  1  0  1  0
];

