function select
% SELECT is the top-level function which selects among the different
% simulations.

v = 1;

while v
   d = dir('*.mat');
   str = cellfun(@(x) x{1}, regexp({d.name},'.+(?=\.mat)','match'), 'UniformOutput',false);
   
   [s,v] = listdlg('PromptString','Select a simulation:','SelectionMode','single',...
                   'ListString',str,'OKstring','Simulate','CancelString','Exit',...
                   'Name','Simulations');
   if v
      [pth,nam] = fileparts(str{s});
      load(nam);
      
      % =====  simulation parameters
      sim_dt         = 0.03;
      sim_factor     = 3;
      pause_dt       = 0.05;
      use_kdtree     = false;

      % =====  simulation preprocessing
      E.Locs   = E.int(cell2mat(E.locs));
      if ~isfield(E, 'angles')
         E.angles = logical([0 0 ones(1,E.d-1) zeros(1,E.d+2)]);
      end
      Nlocs    = angle_expand(E.Locs,E.angles); 
      E.scale  = (diag((diag(cov(Nlocs')).^-0.5)))';
      E.Nlocs  = E.scale*Nlocs;
      if use_kdtree && exist('kdtreeidx','file') 
         [dum1,dum2,E.kdtree] = kdtreeidx(E.Nlocs',[]);
      end
      E.Gains  = cell2mat(E.gains);

      % =====  initialize
      E        = init_graphs(E,0.5*pause_dt*E.dt/(sim_dt*sim_factor));
      x0       = E.x0;
      
      % =====  simulate
      v = sw_play(E,x0,sim_dt,sim_factor,pause_dt);
   end
end
drawnow;
if exist('E','var')
   if isfield(E,'kdtree')
      kdtreeidx([],[],E.kdtree);
   end
end