function dxdt = f(E,x,u)
%f: Swimmer dynamics function.
%   dxdt = f(E,x,u) calculates the dynamics of a d-link swimmer given
%   current states and controls. 
%
%   E is a created by initE() and contains the swimmer's
%   structural parameters.
%
%   The state vector x has 2*d+4 variables, size(x) = [2*d+4 1] =
%   [2 cm coords; d angles; 2 cm velocities; d angular velocities].
%
%   The control vector u has d-1 torques, one for each joint. 
%   size(u)==[d-1 1].
%
%   Author: Yuval Tassa

d     = E.d;

th    = x(3:3+d-1);
vcm   = x(d+3:d+4);
dth   = x(d+5:end);


Tx    = diag(cos(th));
Ty    = diag(sin(th));
Nx    =-diag(sin(th));
Ny    = diag(cos(th));

rVx   = E.P*Nx*dth;
rVy   = E.P*Ny*dth;

Vx    = rVx+vcm(1);
Vy    = rVy+vcm(2);

Vn    = Nx*Vx+Ny*Vy;
Vt    = Tx*Vx+Ty*Vy;

G     = E.P'*E.M*E.P;

DTH   = diag(dth);

EL1   = ((Nx*G*Tx+Ny*G*Ty)*DTH+DTH*(Tx*G*Nx+Ty*G*Ny))*dth;

EL2   =-E.k1*((Nx*E.P'*Nx+Ny*E.P'*Ny)*E.L*Vn+E.L.^3*dth/12)-E.k2*(Nx*E.P'*Tx+Ny*E.P'*Ty)*E.L*Vt;

EL3   = E.I+Nx*G*Nx+Ny*G*Ny;

dxdt(1:2,:)    = vcm;
dxdt(3:d+2,:)  = dth;
dxdt(d+3,:)    =-(E.k1*sum(Nx*Vn)+E.k2*sum(Tx*Vt))/sum(diag(E.M));
dxdt(d+4,:)    =-(E.k1*sum(Ny*Vn)+E.k2*sum(Ty*Vt))/sum(diag(E.M));

dxdt(d+5:2*(d+2),:)=EL3\(EL1+EL2+E.U*u);